/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.AssemblyContext;
import org.apache.maven.plugin.assembly.DefaultAssemblyContext;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.task.AddDependencySetsTask;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

public class DependencySetAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase {
    private MavenProjectBuilder projectBuilder;
    private DependencyResolver dependencyResolver;

    public DependencySetAssemblyPhase() {
    }

    public DependencySetAssemblyPhase(MavenProjectBuilder projectBuilder, DependencyResolver dependencyResolver, Logger logger) {
        this.projectBuilder = projectBuilder;
        this.dependencyResolver = dependencyResolver;
        this.enableLogging(logger);
    }

    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        this.execute(assembly, archiver, configSource, new DefaultAssemblyContext());
    }

    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource, AssemblyContext context) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        AddDependencySetsTask task = new AddDependencySetsTask(assembly.getDependencySets(), configSource.getProject(), context.getManagedVersionMap(), this.projectBuilder, this.dependencyResolver, this.getLogger());
        task.execute(archiver, configSource);
    }
}

