/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.AbstractCoroutine;
import kotlinx.coroutines.test.TestCoroutineScheduler;
import kotlinx.coroutines.test.TestScope;
import kotlinx.coroutines.test.TestScopeImpl;
import kotlinx.coroutines.test.UncaughtExceptionsBeforeTest;
import kotlinx.coroutines.test.UncompletedCoroutinesError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016J\u000e\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0013J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkotlinx/coroutines/test/TestScopeImpl;", "Lkotlinx/coroutines/AbstractCoroutine;", "", "Lkotlinx/coroutines/test/TestScope;", "context", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlin/coroutines/CoroutineContext;)V", "entered", "", "finished", "lock", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "testScheduler", "Lkotlinx/coroutines/test/TestCoroutineScheduler;", "getTestScheduler", "()Lkotlinx/coroutines/test/TestCoroutineScheduler;", "uncaughtExceptions", "", "", "enter", "leave", "", "reportException", "throwable", "toString", "", "tryGetCompletionCause", "kotlinx-coroutines-test"})
public final class TestScopeImpl
extends AbstractCoroutine<Unit>
implements TestScope {
    private boolean entered;
    private boolean finished;
    @NotNull
    private final List<Throwable> uncaughtExceptions = new ArrayList();
    @NotNull
    private final Object lock = new Object();

    public TestScopeImpl(@NotNull CoroutineContext context) {
        super(context, true, true);
    }

    @Override
    @NotNull
    public TestCoroutineScheduler getTestScheduler() {
        CoroutineContext.Element element = this.getContext().get((CoroutineContext.Key)TestCoroutineScheduler.Key);
        Intrinsics.checkNotNull((Object)element);
        return (TestCoroutineScheduler)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enter() {
        List<Throwable> list;
        Object lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            boolean bl = false;
            if (this.entered) {
                throw new IllegalStateException("Only a single call to `runTest` can be performed during one test.");
            }
            this.entered = true;
            if (!(!this.finished)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            list = this.uncaughtExceptions;
        }
        List<Throwable> exceptions = list;
        if (!((Collection)exceptions).isEmpty()) {
            UncaughtExceptionsBeforeTest uncaughtExceptionsBeforeTest;
            UncaughtExceptionsBeforeTest $this$enter_u24lambda_u2d1 = uncaughtExceptionsBeforeTest = new UncaughtExceptionsBeforeTest();
            boolean bl = false;
            for (Throwable e : exceptions) {
                ExceptionsKt.addSuppressed((Throwable)$this$enter_u24lambda_u2d1, (Throwable)e);
            }
            throw (Throwable)uncaughtExceptionsBeforeTest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Throwable> leave() {
        List<Throwable> list;
        Object lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            boolean bl = false;
            if (!this.entered || this.finished) {
                throw new IllegalStateException("An internal error. Please report to the Kotlinx Coroutines issue tracker");
            }
            this.finished = true;
            list = this.uncaughtExceptions;
        }
        List<Throwable> exceptions = list;
        List activeJobs2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)this.getChildren(), (Function1)leave.activeJobs.1.INSTANCE));
        if (exceptions.isEmpty()) {
            if (!((Collection)activeJobs2).isEmpty()) {
                throw new UncompletedCoroutinesError(Intrinsics.stringPlus((String)"Active jobs found during the tear-down. Ensure that all coroutines are completed or cancelled by your test. The active jobs: ", (Object)activeJobs2));
            }
            if (!TestCoroutineScheduler.isIdle$kotlinx_coroutines_test$default(this.getTestScheduler(), false, 1, null)) {
                throw new UncompletedCoroutinesError("Unfinished coroutines found during the tear-down. Ensure that all coroutines are completed or cancelled by your test.");
            }
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reportException(@NotNull Throwable throwable) {
        Object lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            boolean bl = false;
            if (this.finished) {
                throw throwable;
            }
            this.uncaughtExceptions.add(throwable);
            if (!this.entered) {
                UncaughtExceptionsBeforeTest uncaughtExceptionsBeforeTest;
                UncaughtExceptionsBeforeTest $this$reportException_u24lambda_u2d4_u24lambda_u2d3 = uncaughtExceptionsBeforeTest = new UncaughtExceptionsBeforeTest();
                boolean bl2 = false;
                ExceptionsKt.addSuppressed((Throwable)$this$reportException_u24lambda_u2d4_u24lambda_u2d3, (Throwable)throwable);
                throw (Throwable)uncaughtExceptionsBeforeTest;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final Throwable tryGetCompletionCause() {
        return this.getCompletionCause();
    }

    @NotNull
    public String toString() {
        return "TestScope[" + (this.finished ? "test ended" : (this.entered ? "test started" : "test not started")) + ']';
    }
}

