/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.ReasonHeader;

public class Reason
extends ParametersHeader
implements ReasonHeader {
    private static final long serialVersionUID = -8903376965568297388L;
    public final String TEXT = "text";
    public final String CAUSE = "cause";
    protected String protocol;

    public int getCause() {
        return this.getParameterAsInt("cause");
    }

    public void setCause(int cause) throws InvalidArgumentException {
        this.parameters.set("cause", cause);
    }

    public void setProtocol(String protocol) throws ParseException {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setText(String text) throws ParseException {
        if (text != null && text.trim().length() > 0) {
            if (text.charAt(0) != '\"') {
                text = Utils.getQuotedString(text);
            }
            this.parameters.set("text", text);
        }
    }

    public String getText() {
        return this.parameters.getParameter("text");
    }

    public Reason() {
        super("Reason");
    }

    @Override
    public String getName() {
        return "Reason";
    }

    @Override
    public StringBuilder encodeBody(StringBuilder buffer) {
        buffer.append(this.protocol);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            buffer = buffer.append(";");
            buffer = this.parameters.encode(buffer);
        }
        return buffer;
    }
}

