/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.lang.reflect.Method;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.IndicativeSentencesGeneration;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.STABLE, since="5.7")
public interface DisplayNameGenerator {
    public String generateDisplayNameForClass(Class<?> var1);

    public String generateDisplayNameForNestedClass(Class<?> var1);

    public String generateDisplayNameForMethod(Class<?> var1, Method var2);

    public static String parameterTypesAsString(Method method) {
        Preconditions.notNull((Object)method, (String)"Method must not be null");
        return '(' + ClassUtils.nullSafeToString(Class::getSimpleName, (Class[])method.getParameterTypes()) + ')';
    }

    public static DisplayNameGenerator getDisplayNameGenerator(Class<?> generatorClass) {
        Preconditions.notNull(generatorClass, (String)"Class must not be null");
        Preconditions.condition((boolean)DisplayNameGenerator.class.isAssignableFrom(generatorClass), (String)"Class must be a DisplayNameGenerator implementation");
        if (generatorClass == Standard.class) {
            return Standard.INSTANCE;
        }
        if (generatorClass == Simple.class) {
            return Simple.INSTANCE;
        }
        if (generatorClass == ReplaceUnderscores.class) {
            return ReplaceUnderscores.INSTANCE;
        }
        if (generatorClass == IndicativeSentences.class) {
            return IndicativeSentences.INSTANCE;
        }
        return (DisplayNameGenerator)ReflectionUtils.newInstance(generatorClass, (Object[])new Object[0]);
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.7")
    public static class IndicativeSentences
    implements DisplayNameGenerator {
        static final DisplayNameGenerator INSTANCE = new IndicativeSentences();

        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            return this.getGeneratorForIndicativeSentence(testClass).generateDisplayNameForClass(testClass);
        }

        @Override
        public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
            return this.getSentenceBeginning(nestedClass);
        }

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            return this.getSentenceBeginning(testClass) + this.getSentenceSeparator(testClass) + this.getGeneratorForIndicativeSentence(testClass).generateDisplayNameForMethod(testClass, testMethod);
        }

        private String getSentenceBeginning(Class<?> testClass) {
            Class<?> enclosingParent = testClass.getEnclosingClass();
            Optional displayName = AnnotationSupport.findAnnotation(testClass, DisplayName.class);
            Optional displayNameGeneration = AnnotationSupport.findAnnotation(testClass, DisplayNameGeneration.class);
            if (enclosingParent == null || displayNameGeneration.isPresent()) {
                return displayName.map(DisplayName::value).orElseGet(() -> this.generateDisplayNameForClass(testClass));
            }
            String separator = this.getSentenceSeparator(testClass);
            String sentenceBeginning = this.getSentenceBeginning(enclosingParent);
            return displayName.map(name -> sentenceBeginning + separator + name.value()).orElseGet(() -> sentenceBeginning + separator + this.getGeneratorForIndicativeSentence(testClass).generateDisplayNameForNestedClass(testClass));
        }

        private String getSentenceSeparator(Class<?> testClass) {
            Optional<IndicativeSentencesGeneration> indicativeSentencesGeneration = this.getIndicativeSentencesGeneration(testClass);
            if (indicativeSentencesGeneration.isPresent()) {
                if (indicativeSentencesGeneration.get().separator().equals("")) {
                    return ", ";
                }
                return indicativeSentencesGeneration.get().separator();
            }
            return ", ";
        }

        private DisplayNameGenerator getGeneratorForIndicativeSentence(Class<?> testClass) {
            Optional<IndicativeSentencesGeneration> indicativeSentencesGeneration = this.getIndicativeSentencesGeneration(testClass);
            if (indicativeSentencesGeneration.isPresent()) {
                DisplayNameGenerator displayNameGenerator = DisplayNameGenerator.getDisplayNameGenerator(indicativeSentencesGeneration.get().generator());
                if (displayNameGenerator.getClass() == IndicativeSentences.class) {
                    return DisplayNameGenerator.getDisplayNameGenerator(IndicativeSentencesGeneration.DEFAULT_GENERATOR);
                }
                return displayNameGenerator;
            }
            return DisplayNameGenerator.getDisplayNameGenerator(IndicativeSentencesGeneration.DEFAULT_GENERATOR);
        }

        private Optional<IndicativeSentencesGeneration> getIndicativeSentencesGeneration(Class<?> testClass) {
            Optional indicativeSentencesGeneration = AnnotationSupport.findAnnotation(testClass, IndicativeSentencesGeneration.class);
            if (indicativeSentencesGeneration.isPresent()) {
                return indicativeSentencesGeneration;
            }
            if (testClass.getEnclosingClass() != null) {
                return this.getIndicativeSentencesGeneration(testClass.getEnclosingClass());
            }
            return Optional.empty();
        }
    }

    public static class ReplaceUnderscores
    extends Simple {
        static final DisplayNameGenerator INSTANCE = new ReplaceUnderscores();

        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForClass(testClass));
        }

        @Override
        public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForNestedClass(nestedClass));
        }

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForMethod(testClass, testMethod));
        }

        private static String replaceUnderscores(String name) {
            return name.replace('_', ' ');
        }
    }

    public static class Simple
    extends Standard {
        static final DisplayNameGenerator INSTANCE = new Simple();

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            String displayName = testMethod.getName();
            if (Simple.hasParameters(testMethod)) {
                displayName = displayName + ' ' + DisplayNameGenerator.parameterTypesAsString(testMethod);
            }
            return displayName;
        }

        private static boolean hasParameters(Method method) {
            return method.getParameterCount() > 0;
        }
    }

    public static class Standard
    implements DisplayNameGenerator {
        static final DisplayNameGenerator INSTANCE = new Standard();

        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            String name = testClass.getName();
            int lastDot = name.lastIndexOf(46);
            return name.substring(lastDot + 1);
        }

        @Override
        public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
            return nestedClass.getSimpleName();
        }

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            return testMethod.getName() + DisplayNameGenerator.parameterTypesAsString(testMethod);
        }
    }
}

