/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.sctp4j;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jitsi_modified.sctp4j.Sctp4j;
import org.jitsi_modified.sctp4j.SctpDataCallback;
import org.jitsi_modified.sctp4j.SctpDataSender;
import org.jitsi_modified.sctp4j.SctpJni;
import org.jitsi_modified.sctp4j.SctpNotification;

public abstract class SctpSocket {
    private long id;
    protected long ptr;
    public SctpDataSender outgoingDataSender;
    public SctpSocketEventHandler eventHandler;
    private boolean connected = false;
    public SctpDataCallback dataCallback;
    private int ptrLockCount = 0;
    private boolean closed = false;

    public SctpSocket(long ptr, long id) {
        this.id = id;
        this.ptr = ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long lockPtr() throws IOException {
        long ptr;
        SctpSocket sctpSocket = this;
        synchronized (sctpSocket) {
            if (this.closed) {
                throw new IOException("SctpSocket is closed!");
            }
            ptr = this.ptr;
            if (ptr == 0L) {
                throw new IOException("SctpSocket is closed!");
            }
            ++this.ptrLockCount;
        }
        return ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockPtr() {
        long ptr;
        SctpSocket sctpSocket = this;
        synchronized (sctpSocket) {
            int ptrLockCount = this.ptrLockCount - 1;
            if (ptrLockCount < 0) {
                throw new RuntimeException("Unbalanced SctpSocket#unlockPtr() method invocation!");
            }
            this.ptrLockCount = ptrLockCount;
            if (this.closed && ptrLockCount == 0) {
                ptr = this.ptr;
                this.ptr = 0L;
            } else {
                ptr = 0L;
            }
        }
        if (ptr != 0L) {
            Sctp4j.closeSocket(ptr, this.id);
        }
    }

    protected abstract boolean isReady();

    protected boolean socketConnected() {
        return this.ptr != 0L && this.connected;
    }

    private void onNotification(SctpNotification notification) {
        if (notification instanceof SctpNotification.AssociationChange) {
            SctpNotification.AssociationChange associationChange = (SctpNotification.AssociationChange)notification;
            System.out.println("Got sctp association state update: " + associationChange.state);
            switch (associationChange.state) {
                case 1: {
                    boolean wasReady = this.isReady();
                    System.out.println("sctp is now up.  was ready? " + wasReady);
                    this.connected = true;
                    if (!this.isReady() || wasReady || this.eventHandler == null) break;
                    System.out.println("sctp invoking onready");
                    this.eventHandler.onReady();
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    this.connected = false;
                    if (this.eventHandler == null) break;
                    this.eventHandler.onDisconnected();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        long ptr;
        this.closed = true;
        this.connected = false;
        SctpSocket sctpSocket = this;
        synchronized (sctpSocket) {
            if (this.ptrLockCount == 0) {
                ptr = this.ptr;
                this.ptr = 0L;
            } else {
                ptr = 0L;
            }
        }
        if (ptr != 0L) {
            Sctp4j.closeSocket(ptr, this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnIn(byte[] packet, int offset, int len) {
        if (offset < 0 || len <= 0 || offset + len > packet.length) {
            throw new IllegalArgumentException("o: " + offset + " l: " + len + " packet l: " + packet.length);
        }
        try {
            this.lockPtr();
        }
        catch (IOException ioe) {
            System.out.println("Socket isn't open, ignoring incoming data");
            return;
        }
        try {
            SctpJni.on_network_in((long)this.ptr, (byte[])packet, (int)offset, (int)len);
        }
        finally {
            this.unlockPtr();
        }
    }

    void onSctpIn(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        if ((flags & 0x2000) != 0) {
            this.onNotification(SctpNotification.parse(data));
        } else if (this.dataCallback != null) {
            this.dataCallback.onSctpPacket(data, sid, ssn, tsn, ppid, context, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onSctpOut(byte[] packet, int tos, int set_df) {
        int ret = -1;
        try {
            this.lockPtr();
        }
        catch (IOException ioe) {
            return ret;
        }
        try {
            if (this.outgoingDataSender != null) {
                ret = this.outgoingDataSender.send(packet, 0, packet.length);
            }
        }
        finally {
            this.unlockPtr();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(ByteBuffer data, boolean ordered, int sid, int ppid) {
        int ret = -1;
        try {
            this.lockPtr();
        }
        catch (IOException ioe) {
            return ret;
        }
        try {
            if (this.socketConnected()) {
                ret = SctpJni.usrsctp_send((long)this.ptr, (byte[])data.array(), (int)data.arrayOffset(), (int)data.limit(), (boolean)ordered, (int)sid, (int)ppid);
            }
        }
        finally {
            this.unlockPtr();
        }
        return ret;
    }

    public static interface SctpSocketEventHandler {
        public void onReady();

        public void onDisconnected();
    }
}

