/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.sctp4j;

import java.io.IOException;
import org.jitsi_modified.sctp4j.SctpJni;
import org.jitsi_modified.sctp4j.SctpSocket;

public class SctpServerSocket
extends SctpSocket {
    private boolean accepted = false;

    public SctpServerSocket(long ptr, long id) {
        super(ptr, id);
    }

    public void listen() {
        try {
            this.lockPtr();
        }
        catch (IOException ioe) {
            System.out.println("Server socket can't listen: " + ioe.getMessage());
            return;
        }
        try {
            SctpJni.usrsctp_listen((long)this.ptr);
        }
        finally {
            this.unlockPtr();
        }
    }

    @Override
    protected boolean isReady() {
        return this.socketConnected() && this.accepted;
    }

    public boolean accept() {
        boolean ret = false;
        try {
            this.lockPtr();
        }
        catch (IOException ioe) {
            System.out.println("Server can't accept: " + ioe.getMessage());
            return ret;
        }
        try {
            if (SctpJni.usrsctp_accept((long)this.ptr)) {
                this.accepted = true;
                if (this.isReady()) {
                    this.eventHandler.onReady();
                }
                ret = true;
            }
        }
        finally {
            this.unlockPtr();
        }
        return ret;
    }
}

