/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.client.internal;

import com.sonatype.nexus.staging.api.dto.StagingProfileDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileRequestDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileResponseDTO;
import com.sonatype.nexus.staging.client.Profile;
import com.sonatype.nexus.staging.client.internal.JerseyStagingProfiles;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.JerseyEntitySupport;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

public class JerseyStagingProfile
extends JerseyEntitySupport<Profile, StagingProfileDTO>
implements Profile {
    public JerseyStagingProfile(JerseyNexusClient nexusClient) {
        super(nexusClient, null);
    }

    public JerseyStagingProfile(JerseyNexusClient nexusClient, StagingProfileDTO settings) {
        super(nexusClient, settings.getId(), (Object)settings);
    }

    protected StagingProfileDTO createSettings(String id) {
        StagingProfileDTO settings = new StagingProfileDTO();
        settings.setId(id);
        return settings;
    }

    public String id() {
        return ((StagingProfileDTO)this.settings()).getId();
    }

    protected StagingProfileDTO doGet() {
        try {
            return ((StagingProfileResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyStagingProfiles.path(this.id())).get(StagingProfileResponseDTO.class)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    protected StagingProfileDTO doCreate() {
        StagingProfileRequestDTO request = new StagingProfileRequestDTO();
        request.setData((StagingProfileDTO)this.settings());
        try {
            return ((StagingProfileResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource("staging/profiles").post(StagingProfileResponseDTO.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    protected StagingProfileDTO doUpdate() {
        StagingProfileRequestDTO request = new StagingProfileRequestDTO();
        request.setData((StagingProfileDTO)this.settings());
        try {
            return ((StagingProfileResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyStagingProfiles.path(this.id())).put(StagingProfileResponseDTO.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert((UniformInterfaceException)((Object)new JerseyStagingProfiles.StagingProfileNotFoundException(e.getResponse(), this.id())));
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    protected void doRemove() {
        try {
            ((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyStagingProfiles.path(this.id())).delete();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert((UniformInterfaceException)((Object)new JerseyStagingProfiles.StagingProfileNotFoundException(e.getResponse(), this.id())));
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public String name() {
        return ((StagingProfileDTO)this.settings()).getName();
    }

    @Override
    public Profile.AcceptMode mode() {
        return Profile.AcceptMode.valueOf(((StagingProfileDTO)this.settings()).getMode());
    }

    @Override
    public String repositoryTemplateId() {
        return ((StagingProfileDTO)this.settings()).getRepositoryTemplateId();
    }

    @Override
    public String repositoryType() {
        return ((StagingProfileDTO)this.settings()).getRepositoryType();
    }

    @Override
    public String repositoryTargetId() {
        return ((StagingProfileDTO)this.settings()).getRepositoryTargetId();
    }

    @Override
    public String promotionTargetRepositoryId() {
        return ((StagingProfileDTO)this.settings()).getPromotionTargetRepository();
    }

    @Override
    public List<String> targetGroups() {
        return Collections.unmodifiableList(((StagingProfileDTO)this.settings()).getTargetGroups());
    }

    @Override
    public List<String> closeRuleSets() {
        return Collections.unmodifiableList(((StagingProfileDTO)this.settings()).getCloseRuleSets());
    }

    @Override
    public List<String> promoteRuleSets() {
        return Collections.unmodifiableList(((StagingProfileDTO)this.settings()).getPromoteRuleSets());
    }

    @Override
    public Map<String, String> properties() {
        return Collections.unmodifiableMap(((StagingProfileDTO)this.settings()).getProperties());
    }

    @Override
    public JerseyStagingProfile withName(String name) {
        ((StagingProfileDTO)this.settings()).setName(name);
        return this;
    }

    @Override
    public JerseyStagingProfile withMode(Profile.AcceptMode mode) {
        ((StagingProfileDTO)this.settings()).setMode(mode.toString());
        return this;
    }

    @Override
    public JerseyStagingProfile withRepositoryTemplateId(String repositoryTemplateId) {
        ((StagingProfileDTO)this.settings()).setRepositoryTemplateId(repositoryTemplateId);
        return this;
    }

    @Override
    public JerseyStagingProfile withRepositoryType(String repositoryType) {
        ((StagingProfileDTO)this.settings()).setRepositoryType(repositoryType);
        return this;
    }

    @Override
    public JerseyStagingProfile withRepositoryTargetId(String repositoryTargetId) {
        ((StagingProfileDTO)this.settings()).setRepositoryTargetId(repositoryTargetId);
        return this;
    }

    @Override
    public JerseyStagingProfile withPromotionTargetRepositoryId(String repositoryId) {
        ((StagingProfileDTO)this.settings()).setPromotionTargetRepository(repositoryId);
        return this;
    }

    @Override
    public JerseyStagingProfile withTargetGroups(String ... targetGroups) {
        if (targetGroups != null) {
            ((StagingProfileDTO)this.settings()).setTargetGroups(Arrays.asList(targetGroups));
        } else {
            ((StagingProfileDTO)this.settings()).getTargetGroups().clear();
        }
        return this;
    }

    @Override
    public JerseyStagingProfile addTargetGroups(String ... targetGroups) {
        if (targetGroups != null) {
            for (String targetGroup : targetGroups) {
                ((StagingProfileDTO)this.settings()).addTargetGroup(targetGroup);
            }
        }
        return this;
    }

    @Override
    public JerseyStagingProfile removeTargetGroups(String ... targetGroups) {
        if (targetGroups != null) {
            for (String targetGroup : targetGroups) {
                ((StagingProfileDTO)this.settings()).getTargetGroups().remove(targetGroup);
            }
        }
        return this;
    }

    @Override
    public JerseyStagingProfile withCloseRuleSets(String ... ruleSets) {
        if (ruleSets != null) {
            ((StagingProfileDTO)this.settings()).setCloseRuleSets(Arrays.asList(ruleSets));
        } else {
            ((StagingProfileDTO)this.settings()).getCloseRuleSets().clear();
        }
        return this;
    }

    @Override
    public JerseyStagingProfile addCloseRuleSets(String ... ruleSets) {
        if (ruleSets != null) {
            for (String ruleSet : ruleSets) {
                ((StagingProfileDTO)this.settings()).addCloseRuleSet(ruleSet);
            }
        }
        return this;
    }

    @Override
    public JerseyStagingProfile removeCloseRuleSets(String ... ruleSets) {
        if (ruleSets != null) {
            for (String ruleSet : ruleSets) {
                ((StagingProfileDTO)this.settings()).getCloseRuleSets().remove(ruleSet);
            }
        }
        return this;
    }

    @Override
    public JerseyStagingProfile withPromoteRuleSets(String ... ruleSets) {
        if (ruleSets != null) {
            ((StagingProfileDTO)this.settings()).setPromoteRuleSets(Arrays.asList(ruleSets));
        } else {
            ((StagingProfileDTO)this.settings()).getPromoteRuleSets().clear();
        }
        return this;
    }

    @Override
    public JerseyStagingProfile addPromoteRuleSets(String ... ruleSets) {
        if (ruleSets != null) {
            for (String ruleSet : ruleSets) {
                ((StagingProfileDTO)this.settings()).addPromoteRuleSet(ruleSet);
            }
        }
        return this;
    }

    @Override
    public JerseyStagingProfile removePromoteRuleSets(String ... ruleSets) {
        if (ruleSets != null) {
            for (String ruleSet : ruleSets) {
                ((StagingProfileDTO)this.settings()).getPromoteRuleSets().remove(ruleSet);
            }
        }
        return this;
    }

    @Override
    public JerseyStagingProfile setProperty(String name, String value) {
        ((StagingProfileDTO)this.settings()).getProperties().put(name, value);
        return this;
    }

    @Override
    public JerseyStagingProfile removeProperty(String name) {
        ((StagingProfileDTO)this.settings()).getProperties().remove(name);
        return this;
    }

    @Override
    public JerseyStagingProfile clearProperties() {
        ((StagingProfileDTO)this.settings()).getProperties().clear();
        return this;
    }

    public String toString() {
        return "Profile{id='" + this.id() + '\'' + ", name='" + this.name() + '\'' + ", contentClass='" + this.repositoryType() + '\'' + ", promotionTargetRepository='" + this.promotionTargetRepositoryId() + '\'' + ", properties=" + this.properties() + '}';
    }
}

