/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentLengthHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.SipInitialLine;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class SipMessageBuilder<T extends SipMessage>
implements SipMessage.Builder<T> {
    private final List<SipHeader> headers;
    private Predicate<SipHeader> filter;
    private Function<SipURI, SipURI> onRequestURIFunction;
    private CSeqHeader cseq;
    private CSeqHeader.Builder cseqBuilder;
    private MaxForwardsHeader maxForwards;
    private Consumer<MaxForwardsHeader.Builder> onMaxForwardsBuilder;
    private Consumer<AddressParametersHeader.Builder<ToHeader>> onToBuilder;
    private Consumer<AddressParametersHeader.Builder<FromHeader>> onFromBuilder;
    private Consumer<AddressParametersHeader.Builder<ContactHeader>> onContactBuilder;
    private List<ViaHeader> viaHeaders;
    private Consumer<ViaHeader.Builder> onTopMostViaBuilder;
    private BiConsumer<Integer, ViaHeader.Builder> onViaBuilder;
    private List<RecordRouteHeader> recordRouteHeaders;
    private Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> onTopMostRecordRouteBuilder;
    private Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> onRecordRouteBuilder;
    private List<RouteHeader> routeHeaders;
    private Consumer<AddressParametersHeader.Builder<RouteHeader>> onTopMostRouteBuilder;
    private Consumer<AddressParametersHeader.Builder<RouteHeader>> onRouteBuilder;
    private Function<SipHeader, SipHeader> onHeaderFunction;
    private Buffer body;
    private short indexOfTo = (short)-1;
    private short indexOfFrom = (short)-1;
    private short indexOfCSeq = (short)-1;
    private short indexOfCallId = (short)-1;
    private short indexOfMaxForwards = (short)-1;
    private short indexOfVia = (short)-1;
    private short indexOfRoute = (short)-1;
    private short indexOfRecordRoute = (short)-1;
    private short indexOfContact = (short)-1;
    private boolean useDefaults = true;

    protected SipMessageBuilder(int headerSizeHint) {
        this.headers = new ArrayList<SipHeader>(headerSizeHint);
    }

    protected SipMessageBuilder() {
        this(15);
    }

    @Override
    public SipMessage.Builder<T> withNoDefaults() {
        this.useDefaults = false;
        return this;
    }

    @Override
    public SipMessage.Builder<T> onHeader(Function<SipHeader, SipHeader> f) throws IllegalStateException {
        this.onHeaderFunction = this.onHeaderFunction == null ? f : this.onHeaderFunction.andThen(f);
        return this;
    }

    private void processHeader(SipHeader header) {
        if (header.isContactHeader()) {
            this.indexOfContact = this.addTrackedHeader(this.indexOfContact, header);
        } else if (header.isCSeqHeader()) {
            this.indexOfCSeq = this.addTrackedHeader(this.indexOfCSeq, header);
        } else if (header.isMaxForwardsHeader()) {
            this.indexOfMaxForwards = this.addTrackedHeader(this.indexOfMaxForwards, header);
        } else if (header.isFromHeader()) {
            this.indexOfFrom = this.addTrackedHeader(this.indexOfFrom, header);
        } else if (header.isToHeader()) {
            this.indexOfTo = this.addTrackedHeader(this.indexOfTo, header);
        } else if (header.isViaHeader()) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.add(header.ensure().toViaHeader());
            this.indexOfVia = this.addTrackedListHeader(this.indexOfVia);
        } else if (header.isCallIdHeader()) {
            this.indexOfCallId = this.addTrackedHeader(this.indexOfCallId, header);
        } else if (header.isRouteHeader()) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.add(header.ensure().toRouteHeader());
            this.indexOfRoute = this.addTrackedListHeader(this.indexOfRoute);
        } else if (header.isRecordRouteHeader()) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.add(header.ensure().toRecordRouteHeader());
            this.indexOfRecordRoute = this.addTrackedListHeader(this.indexOfRecordRoute);
        } else {
            this.addHeader(header);
        }
    }

    private short addTrackedListHeader(short index) {
        if (index != -1) {
            return index;
        }
        return this.addHeader(null);
    }

    private short addTrackedHeader(short index, SipHeader header) {
        if (index != -1) {
            this.headers.set(index, header.ensure());
            return index;
        }
        return this.addHeader(header.ensure());
    }

    private short addHeader(SipHeader header) {
        this.headers.add(header);
        return (short)(this.headers.size() - 1);
    }

    @Override
    public SipMessage.Builder<T> withHeader(SipHeader header) {
        if (header != null) {
            this.processHeader(header);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withHeaders(List<SipHeader> headers) {
        if (headers != null) {
            headers.forEach(this::processHeader);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withPushHeader(SipHeader header) {
        return this;
    }

    @Override
    public SipMessage.Builder<T> onFromHeader(Consumer<AddressParametersHeader.Builder<FromHeader>> f) {
        this.onFromBuilder = this.onFromBuilder != null ? this.onFromBuilder.andThen(f) : f;
        return this;
    }

    @Override
    public SipMessage.Builder<T> withFromHeader(FromHeader from) {
        if (from != null) {
            this.indexOfFrom = this.addTrackedHeader(this.indexOfFrom, from);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withFromHeader(String from) {
        return this.withFromHeader(FromHeader.frame(Buffers.wrap((String)from)));
    }

    @Override
    public SipMessage.Builder<T> onToHeader(Consumer<AddressParametersHeader.Builder<ToHeader>> f) {
        this.onToBuilder = this.onToBuilder != null ? this.onToBuilder.andThen(f) : f;
        return this;
    }

    @Override
    public SipMessage.Builder<T> withToHeader(ToHeader to) {
        if (to != null) {
            this.indexOfTo = this.addTrackedHeader(this.indexOfTo, to);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withToHeader(String to) {
        return this.withToHeader(ToHeader.frame(Buffers.wrap((String)to)));
    }

    @Override
    public SipMessage.Builder<T> onContactHeader(Consumer<AddressParametersHeader.Builder<ContactHeader>> f) {
        this.onContactBuilder = this.onContactBuilder != null ? this.onContactBuilder.andThen(f) : f;
        return this;
    }

    @Override
    public SipMessage.Builder<T> withContactHeader(ContactHeader contact) {
        if (contact != null) {
            this.indexOfContact = this.addTrackedHeader(this.indexOfContact, contact);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> onCSeqHeader(Consumer<CSeqHeader.Builder> f) {
        return this;
    }

    @Override
    public SipMessage.Builder<T> withCSeqHeader(CSeqHeader cseq) {
        if (cseq != null) {
            this.indexOfCSeq = this.addTrackedHeader(this.indexOfCSeq, cseq);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withCallIdHeader(CallIdHeader callID) {
        if (callID != null) {
            this.indexOfCallId = this.addTrackedHeader(this.indexOfCallId, callID);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> onMaxForwardsHeader(Consumer<MaxForwardsHeader.Builder> f) {
        if (this.onMaxForwardsBuilder != null) {
            this.onMaxForwardsBuilder.andThen(f);
        } else {
            this.onMaxForwardsBuilder = f;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withMaxForwardsHeader(MaxForwardsHeader maxForwards) {
        this.indexOfMaxForwards = this.addTrackedHeader(this.indexOfMaxForwards, maxForwards);
        return this;
    }

    @Override
    public SipMessage.Builder<T> onTopMostViaHeader(Consumer<ViaHeader.Builder> f) {
        this.onTopMostViaBuilder = this.chainConsumers(this.onTopMostViaBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> onViaHeader(BiConsumer<Integer, ViaHeader.Builder> f) {
        this.onViaBuilder = this.chainConsumers(this.onViaBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> onTopMostRouteHeader(Consumer<AddressParametersHeader.Builder<RouteHeader>> f) {
        this.onTopMostRouteBuilder = this.chainConsumers(this.onTopMostRouteBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> onRouteHeader(Consumer<AddressParametersHeader.Builder<RouteHeader>> f) {
        this.onRouteBuilder = this.chainConsumers(this.onRouteBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRouteHeader(RouteHeader route) {
        if (route != null) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.clear();
            this.routeHeaders.add(route);
            this.indexOfRoute = this.addTrackedListHeader(this.indexOfRoute);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRouteHeaders(RouteHeader ... routes) {
        if (routes != null) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.clear();
            for (RouteHeader route : routes) {
                this.routeHeaders.add(route);
            }
            this.indexOfRoute = this.addTrackedListHeader(this.indexOfRoute);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRouteHeaders(List<RouteHeader> routes) {
        if (routes != null && !routes.isEmpty()) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.clear();
            routes.forEach(this.routeHeaders::add);
            this.indexOfRoute = this.addTrackedListHeader(this.indexOfRoute);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withTopMostRouteHeader(RouteHeader route) {
        if (route != null) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.add(0, route);
            this.indexOfRoute = this.addTrackedListHeader(this.indexOfRoute);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withPoppedRoute() {
        if (this.routeHeaders != null) {
            this.routeHeaders.remove(0);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withNoRoutes() {
        if (this.routeHeaders != null) {
            this.routeHeaders.clear();
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> onTopMostRecordRouteHeader(Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> f) {
        this.onTopMostRecordRouteBuilder = this.chainConsumers(this.onTopMostRecordRouteBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> onRecordRouteHeader(Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> f) {
        this.onRecordRouteBuilder = this.chainConsumers(this.onRecordRouteBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRecordRouteHeader(RecordRouteHeader recordRoute) {
        if (recordRoute != null) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.clear();
            this.recordRouteHeaders.add(recordRoute);
            this.indexOfRecordRoute = this.addTrackedListHeader(this.indexOfRecordRoute);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRecordRouteHeaders(RecordRouteHeader ... recordRoutes) {
        if (recordRoutes != null) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.clear();
            for (RecordRouteHeader rr : recordRoutes) {
                this.recordRouteHeaders.add(rr);
            }
            this.indexOfRecordRoute = this.addTrackedListHeader(this.indexOfRecordRoute);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRecordRouteHeaders(List<RecordRouteHeader> recordRoutes) {
        if (recordRoutes != null && !recordRoutes.isEmpty()) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.clear();
            recordRoutes.forEach(this.recordRouteHeaders::add);
            this.indexOfRecordRoute = this.addTrackedListHeader(this.indexOfRecordRoute);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withTopMostRecordRouteHeader(RecordRouteHeader recordRoute) {
        if (recordRoute != null) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.add(0, recordRoute);
            this.indexOfRecordRoute = this.addTrackedListHeader(this.indexOfRecordRoute);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withViaHeader(ViaHeader via) {
        if (via != null) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.clear();
            this.viaHeaders.add(via);
            this.indexOfVia = this.addTrackedListHeader(this.indexOfVia);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withViaHeaders(ViaHeader ... vias) {
        if (vias != null) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.clear();
            for (ViaHeader via : vias) {
                this.viaHeaders.add(via);
            }
            this.indexOfVia = this.addTrackedListHeader(this.indexOfVia);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withViaHeaders(List<ViaHeader> vias) {
        if (vias != null) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.clear();
            vias.forEach(this.viaHeaders::add);
            this.indexOfVia = this.addTrackedListHeader(this.indexOfVia);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withTopMostViaHeader(ViaHeader via) {
        if (via != null) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.add(0, via);
            this.indexOfVia = this.addTrackedListHeader(this.indexOfVia);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withTopMostViaHeader() {
        this.viaHeaders = this.ensureList(this.viaHeaders);
        this.viaHeaders.add(0, null);
        this.indexOfVia = this.addTrackedListHeader(this.indexOfVia);
        return this;
    }

    @Override
    public SipMessage.Builder<T> withPoppedVia() {
        if (this.viaHeaders != null) {
            this.viaHeaders.remove(0);
        }
        return this;
    }

    protected final Function<SipURI, SipURI> getRequestURIFunction() {
        return this.onRequestURIFunction;
    }

    private <T> List<T> ensureList(List<T> list) {
        if (list != null) {
            return list;
        }
        return new ArrayList(4);
    }

    @Override
    public SipMessage.Builder<T> onRequestURI(Function<SipURI, SipURI> f) {
        this.onRequestURIFunction = this.onRequestURIFunction == null ? f : this.onRequestURIFunction.andThen(f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> withBody(Buffer body) {
        if (body != null) {
            this.body = body.slice();
        }
        return this;
    }

    private final int sizeOf(List<?> list) {
        return list == null ? 0 : list.size() - 1;
    }

    private void enforceDefaults() {
        if (this.indexOfTo == -1) {
            this.withToHeader(this.generateDefaultToHeader());
        }
        if (this.isBuildingRequest() && this.indexOfMaxForwards == -1) {
            this.withMaxForwardsHeader(MaxForwardsHeader.create());
        }
        if (this.indexOfCallId == -1) {
            this.withCallIdHeader(CallIdHeader.create());
        }
        if (this.indexOfCSeq == -1) {
            this.withCSeqHeader(this.generateDefaultCSeqHeader());
        }
    }

    protected boolean isBuildingRequest() {
        return false;
    }

    protected boolean isBuildingResponse() {
        return false;
    }

    protected abstract ToHeader generateDefaultToHeader();

    protected abstract CSeqHeader generateDefaultCSeqHeader();

    @Override
    public T build() {
        int msgSize = 2;
        short currentIndexOfVia = this.indexOfVia;
        short currentIndexOfRoute = this.indexOfRoute;
        short currentIndexOfRecordRoute = this.indexOfRecordRoute;
        int headerCount = this.headers.size() + this.sizeOf(this.viaHeaders) + this.sizeOf(this.recordRouteHeaders) + this.sizeOf(this.routeHeaders);
        ArrayList<SipHeader> finalHeaders = new ArrayList<SipHeader>(headerCount);
        SipHeader contentLengthHeader = null;
        if (this.useDefaults) {
            this.enforceDefaults();
        }
        this.indexOfTo = (short)-1;
        this.indexOfFrom = (short)-1;
        this.indexOfCSeq = (short)-1;
        this.indexOfCallId = (short)-1;
        this.indexOfMaxForwards = (short)-1;
        this.indexOfVia = (short)-1;
        this.indexOfRoute = (short)-1;
        this.indexOfRecordRoute = (short)-1;
        this.indexOfContact = (short)-1;
        for (int i = 0; i < this.headers.size(); ++i) {
            Consumer<AddressParametersHeader.Builder<Object>> f;
            SipHeader header = this.headers.get(i);
            if (header != null) {
                SipHeader finalHeader = this.processFinalHeader((short)finalHeaders.size(), header);
                if (finalHeader == null) continue;
                if (finalHeader.isContentLengthHeader()) {
                    contentLengthHeader = finalHeader;
                    continue;
                }
                msgSize += finalHeader.getBufferSize() + 2;
                finalHeaders.add(finalHeader);
                continue;
            }
            if (i == currentIndexOfVia) {
                if (this.viaHeaders == null) continue;
                for (int j = 0; j < this.viaHeaders.size(); ++j) {
                    ViaHeader finalVia = this.processVia(j, this.viaHeaders.get(j));
                    msgSize += finalVia.getBufferSize() + 2;
                    if (j == 0) {
                        this.indexOfVia = (short)finalHeaders.size();
                    }
                    finalHeaders.add(finalVia);
                }
                continue;
            }
            if (i == currentIndexOfRecordRoute) {
                if (this.recordRouteHeaders == null) continue;
                for (int j = 0; j < this.recordRouteHeaders.size(); ++j) {
                    f = j == 0 ? this.onTopMostRecordRouteBuilder : this.onRecordRouteBuilder;
                    RecordRouteHeader finalRR = this.invokeAddressBuilderFunction(f, this.recordRouteHeaders.get(j).ensure().toRecordRouteHeader());
                    msgSize += finalRR.getBufferSize() + 2;
                    if (j == 0) {
                        this.indexOfRecordRoute = (short)finalHeaders.size();
                    }
                    finalHeaders.add(finalRR);
                }
                continue;
            }
            if (i != currentIndexOfRoute || this.routeHeaders == null) continue;
            for (int j = 0; j < this.routeHeaders.size(); ++j) {
                f = j == 0 ? this.onTopMostRouteBuilder : this.onRouteBuilder;
                RouteHeader finalRoute = this.invokeAddressBuilderFunction(f, this.routeHeaders.get(j).ensure().toRouteHeader());
                msgSize += finalRoute.getBufferSize() + 2;
                if (j == 0) {
                    this.indexOfRoute = (short)finalHeaders.size();
                }
                finalHeaders.add(finalRoute);
            }
        }
        Buffer body = this.body;
        if (this.isBuildingRequest() && this.useDefaults) {
            contentLengthHeader = ContentLengthHeader.create(body == null ? 0 : body.capacity());
        }
        if (contentLengthHeader != null) {
            msgSize += contentLengthHeader.getBufferSize() + 2;
            finalHeaders.add(contentLengthHeader);
        }
        SipInitialLine initialLine = this.buildInitialLine();
        Buffer initialLineBuffer = initialLine.getBuffer();
        msgSize += initialLineBuffer.getReadableBytes() + 2;
        if (body != null) {
            msgSize += body.getReadableBytes();
        }
        Buffer msg = Buffers.createBuffer((int)msgSize);
        initialLineBuffer.getBytes(msg);
        msg.write((byte)13);
        msg.write((byte)10);
        for (SipHeader header : finalHeaders) {
            header.getBytes(msg);
            msg.write((byte)13);
            msg.write((byte)10);
        }
        msg.write((byte)13);
        msg.write((byte)10);
        if (body != null) {
            body.getBytes(msg);
        }
        return this.internalBuild(msg, initialLine, finalHeaders, this.indexOfTo, this.indexOfFrom, this.indexOfCSeq, this.indexOfCallId, this.indexOfMaxForwards, this.indexOfVia, this.indexOfRoute, this.indexOfRecordRoute, this.indexOfContact, body);
    }

    private ViaHeader processVia(int index, SipHeader header) throws SipParseException {
        ViaHeader.Builder builder;
        if (index > 0 && this.onViaBuilder == null) {
            if (header == null) {
                throw new SipParseException("You cannot register an empty Via-header and then not also register a function for that via. Please refer to javadoc");
            }
            return header.ensure().toViaHeader();
        }
        if (index == 0 && this.onTopMostViaBuilder == null) {
            if (header == null) {
                throw new SipParseException("You cannot register an empty top-most Via-header and then not also register a function for that top-most via. Please refer to the javadoc");
            }
            return header.ensure().toViaHeader();
        }
        ViaHeader.Builder builder2 = builder = header == null ? ViaHeader.builder() : header.ensure().toViaHeader().copy();
        if (index == 0) {
            this.onTopMostViaBuilder.accept(builder);
        } else {
            this.onViaBuilder.accept(index, builder);
        }
        return builder.build();
    }

    protected abstract SipInitialLine buildInitialLine() throws SipParseException;

    protected abstract T internalBuild(Buffer var1, SipInitialLine var2, List<SipHeader> var3, short var4, short var5, short var6, short var7, short var8, short var9, short var10, short var11, short var12, Buffer var13);

    private SipHeader processFinalHeader(short index, SipHeader header) {
        SipHeader finalHeader = header;
        if (header.isContactHeader()) {
            this.indexOfContact = index;
            finalHeader = this.invokeContactHeaderFunction(header.ensure().toContactHeader());
        } else if (header.isCSeqHeader()) {
            this.indexOfCSeq = index;
            finalHeader = header.ensure().toCSeqHeader();
        } else if (header.isMaxForwardsHeader()) {
            finalHeader = this.invokeMaxForwardsFunction(header.ensure().toMaxForwardsHeader());
            this.indexOfMaxForwards = index;
        } else if (header.isFromHeader()) {
            this.indexOfFrom = index;
            finalHeader = this.invokeFromHeaderFunction(header.ensure().toFromHeader());
        } else if (header.isToHeader()) {
            this.indexOfTo = index;
            finalHeader = this.invokeToHeaderFunction(header.ensure().toToHeader());
        } else if (header.isCallIdHeader()) {
            finalHeader = header.ensure().toCallIdHeader();
            this.indexOfCallId = index;
        } else {
            finalHeader = this.processGenericHeader(header);
        }
        return finalHeader;
    }

    private <T extends SipHeader> T invokeSipHeaderBuilderFunction(Consumer<SipHeader.Builder<T>> f, T header) {
        if (header != null && f != null) {
            SipHeader.Builder b = header.copy();
            f.accept(b);
            return (T)b.build();
        }
        return header;
    }

    private <T extends AddressParametersHeader> T invokeAddressBuilderFunction(Consumer<AddressParametersHeader.Builder<T>> f, T header) {
        if (header != null && f != null) {
            AddressParametersHeader.Builder b = header.copy();
            f.accept(b);
            return (T)b.build();
        }
        return header;
    }

    private SipHeader processGenericHeader(SipHeader header) {
        if (this.onHeaderFunction != null) {
            return this.onHeaderFunction.apply(header);
        }
        return header;
    }

    private ToHeader invokeToHeaderFunction(ToHeader to) {
        if (to != null && this.onToBuilder != null) {
            ToHeader.Builder b = to.copy();
            this.onToBuilder.accept(b);
            return (ToHeader)b.build();
        }
        return to;
    }

    private ContactHeader invokeContactHeaderFunction(ContactHeader contact) {
        if (contact != null && this.onContactBuilder != null) {
            ContactHeader.Builder b = contact.copy();
            this.onContactBuilder.accept(b);
            return (ContactHeader)b.build();
        }
        return contact;
    }

    private FromHeader invokeFromHeaderFunction(FromHeader from) {
        if (from != null && this.onFromBuilder != null) {
            SipHeader.Builder b = from.copy();
            this.onFromBuilder.accept((AddressParametersHeader.Builder<FromHeader>)b);
            return (FromHeader)((AddressParametersHeader.Builder)b).build();
        }
        return from;
    }

    private MaxForwardsHeader invokeMaxForwardsFunction(MaxForwardsHeader max) {
        if (max != null && this.onMaxForwardsBuilder != null) {
            MaxForwardsHeader.Builder b = max.copy();
            this.onMaxForwardsBuilder.accept(b);
            return b.build();
        }
        return max;
    }

    @Override
    public SipMessage.Builder<T> onCommit(Consumer<SipMessage> f) {
        return this;
    }

    private <T> Consumer<T> chainConsumers(Consumer<T> currentConsumer, Consumer<T> consumer) {
        if (currentConsumer != null) {
            return currentConsumer.andThen(consumer);
        }
        return consumer;
    }

    private <T, S> BiConsumer<T, S> chainConsumers(BiConsumer<T, S> currentConsumer, BiConsumer<T, S> consumer) {
        if (currentConsumer != null) {
            return currentConsumer.andThen(consumer);
        }
        return consumer;
    }
}

