/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.ByteNotFoundException;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.impl.SipParser;
import io.pkts.packet.sip.impl.SipRequestLine;
import io.pkts.packet.sip.impl.SipResponseLine;
import java.io.IOException;

public abstract class SipInitialLine
extends SipParser {
    protected SipInitialLine() {
    }

    public abstract boolean equals(Object var1);

    public abstract Buffer getBuffer();

    public static boolean isResponseLine(Buffer buffer) throws IOException {
        if (buffer == null || buffer.getReadableBytes() < 7) {
            return false;
        }
        byte a = buffer.getByte(0);
        byte b = buffer.getByte(1);
        byte c = buffer.getByte(2);
        byte d = buffer.getByte(3);
        byte e = buffer.getByte(4);
        byte f = buffer.getByte(5);
        byte g = buffer.getByte(6);
        return a == 83 && b == 73 && c == 80 && d == 47 && e == 50 && f == 46 && g == 48;
    }

    public static final SipInitialLine parse(Buffer buffer) throws SipParseException {
        Buffer part1 = null;
        Buffer part2 = null;
        Buffer part3 = null;
        try {
            part1 = buffer.readUntil((byte)32);
            part2 = buffer.readUntil((byte)32);
            part3 = buffer.readLine();
            if (SipParser.SIP2_0.equals((Object)part1)) {
                int statusCode = part2.parseToInt();
                return new SipResponseLine(statusCode, part3);
            }
            SipInitialLine.expectSIP2_0(part3);
            return new SipRequestLine(part1, part2);
        }
        catch (NumberFormatException e) {
            int index = buffer.getReaderIndex() - part3.capacity() - part2.capacity() - 1;
            throw new SipParseException(index, "unable to parse the SIP response code as an integer");
        }
        catch (ByteNotFoundException e) {
            throw new SipParseException(buffer.getReaderIndex(), "expected space");
        }
        catch (SipParseException e) {
            e.printStackTrace();
            int index = buffer.getReaderIndex() - part3.capacity() + e.getErrorOffset() - 1;
            throw new SipParseException(index, "Wrong SIP version");
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "could not read from stream", e);
        }
    }

    public static final SipInitialLine parse(Buffer part1, Buffer part2, Buffer part3) throws SipParseException {
        try {
            if (SipParser.SIP2_0.equals((Object)part1)) {
                int statusCode = part2.parseToInt();
                return new SipResponseLine(statusCode, part3);
            }
            SipInitialLine.expectSIP2_0(part3);
            return new SipRequestLine(part1, part2);
        }
        catch (NumberFormatException e) {
            throw new SipParseException(part1.capacity() + 1, "unable to parse the SIP response code as an integer");
        }
        catch (SipParseException e) {
            throw new SipParseException(part1.capacity() + 1 + part2.capacity() + 1, "Wrong SIP version");
        }
        catch (IOException e) {
            throw new SipParseException(0, "could not read from stream", e);
        }
    }

    public SipRequestLine toRequestLine() {
        throw new ClassCastException("Cannot cast object to " + SipRequestLine.class);
    }

    public SipResponseLine toResponseLine() {
        throw new ClassCastException("Cannot cast object to " + SipResponseLine.class);
    }

    public boolean isResponseLine() {
        return false;
    }

    public boolean isRequestLine() {
        return false;
    }

    public abstract void getBytes(Buffer var1);

    protected abstract SipInitialLine clone();
}

