/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.buffer.ByteNotFoundException;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.address.impl.AddressImpl;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;

public interface Address {
    public Buffer getDisplayName();

    public URI getURI() throws SipParseException;

    public Buffer toBuffer();

    public void getBytes(Buffer var1);

    public Builder copy();

    public static Address frame(String buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        return Address.frame(Buffers.wrap((String)buffer));
    }

    public static Address frame(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        SipParser.consumeWS(buffer);
        Buffer original = buffer.slice();
        boolean doubleQuote = false;
        if (buffer.peekByte() == 34) {
            doubleQuote = true;
        }
        Buffer displayName = SipParser.consumeDisplayName(buffer);
        boolean leftAngleBracket = true;
        if (doubleQuote && displayName.isEmpty()) {
            SipParser.consumeWS(buffer);
        }
        if (displayName.isEmpty() && buffer.peekByte() == 60) {
            buffer.readByte();
        } else if (!displayName.isEmpty()) {
            SipParser.consumeWS(buffer);
            SipParser.expect(buffer, (byte)60);
        } else {
            leftAngleBracket = false;
        }
        Buffer addrSpec = null;
        if (!leftAngleBracket) {
            try {
                int index = buffer.indexOf(1024, new byte[]{59, 63, 13, 10});
                if (index >= 0) {
                    Buffer temp = buffer.readBytes(index - buffer.getReaderIndex());
                    addrSpec = SipParser.consumeAddressSpec(temp);
                }
                addrSpec = SipParser.consumeAddressSpec(buffer);
            }
            catch (ByteNotFoundException e) {
                throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the uri (addr-spec) portion of the address");
            }
        } else {
            addrSpec = SipParser.consumeAddressSpec(buffer);
        }
        if (addrSpec == null) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to find the name-addr portion");
        }
        if (displayName.isEmpty() && buffer.hasReadableBytes() && buffer.peekByte() == 62) {
            buffer.readByte();
        } else if (!displayName.isEmpty()) {
            SipParser.expect(buffer, (byte)62);
        }
        URI uri = URI.frame(addrSpec);
        return new AddressImpl(original, displayName, uri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder withHost(Buffer host) {
        Builder builder = new Builder();
        return builder.withHost(PreConditions.assertNotNull(host, "host cannot be null"));
    }

    public static Builder withHost(String host) {
        Builder builder = new Builder();
        return builder.withHost(PreConditions.assertNotNull(host, "host cannot be null"));
    }

    public static Builder withURI(URI uri) {
        Builder builder = new Builder();
        builder.withURI(uri);
        return builder;
    }

    public static class Builder {
        private SipURI.Builder uriBuilder;
        private Buffer displayName;

        private Builder() {
        }

        public Builder withUser(Buffer user) {
            this.ensureURIBuilder().withUser(user);
            return this;
        }

        public Builder withUser(String user) {
            this.ensureURIBuilder().withUser(user);
            return this;
        }

        public Builder withPort(int port) {
            this.ensureURIBuilder().withPort(port);
            return this;
        }

        public Builder withURIParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            this.ensureURIBuilder().withParameter(name, value);
            return this;
        }

        public Builder withURIParameter(String name, String value) throws SipParseException, IllegalArgumentException {
            this.ensureURIBuilder().withParameter(name, value);
            return this;
        }

        public Builder withURIParameter(String name, int value) throws SipParseException, IllegalArgumentException {
            this.ensureURIBuilder().withParameter(name, value);
            return this;
        }

        public Builder withURIParameter(Buffer name, int value) throws SipParseException, IllegalArgumentException {
            this.ensureURIBuilder().withParameter(name, value);
            return this;
        }

        public Builder withNoParameters() {
            this.ensureURIBuilder().withNoParameters();
            return this;
        }

        public Builder withTransportUDP() {
            this.ensureURIBuilder().useUDP();
            return this;
        }

        public Builder withTransportTCP() {
            this.ensureURIBuilder().useTCP();
            return this;
        }

        public Builder withTransportTLS() {
            this.ensureURIBuilder().useTLS();
            return this;
        }

        public Builder withTransportSCTP() {
            this.ensureURIBuilder().useSCTP();
            return this;
        }

        public Builder withTransport(Buffer transport) throws SipParseException {
            this.ensureURIBuilder().withTransport(transport);
            return this;
        }

        public Builder withTransport(String transport) throws SipParseException {
            this.ensureURIBuilder().withTransport(transport);
            return this;
        }

        public Builder withTransportWS() {
            this.ensureURIBuilder().useWS();
            return this;
        }

        public Builder withTransportWSS() {
            this.ensureURIBuilder().useWSS();
            return this;
        }

        public Builder withHost(Buffer host) {
            this.ensureURIBuilder().withHost(host);
            return this;
        }

        public Builder withHost(String host) {
            this.ensureURIBuilder().withHost(host);
            return this;
        }

        public Builder withDisplayName(Buffer displayName) {
            this.displayName = PreConditions.ifNull(displayName, Buffers.EMPTY_BUFFER);
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = Buffers.wrap((String)PreConditions.ifNull(displayName, ""));
            return this;
        }

        private SipURI.Builder ensureURIBuilder() {
            if (this.uriBuilder == null) {
                this.uriBuilder = SipURI.builder();
            }
            return this.uriBuilder;
        }

        public Builder withURI(URI uri) {
            PreConditions.assertNotNull(uri, "URI cannot be null");
            PreConditions.assertArgument(uri.isSipURI(), "Can only do SIP URIs right now");
            this.uriBuilder = uri.toSipURI().copy();
            return this;
        }

        public Address build() throws SipParseException {
            boolean yesAngleQuoteIt;
            boolean yesDisplayName;
            SipURI uri = this.uriBuilder.build();
            Buffer uriBuffer = uri.toBuffer();
            int size = uriBuffer.capacity();
            boolean doubleQuoteIt = false;
            boolean bl = yesDisplayName = this.displayName != null && !this.displayName.isEmpty();
            if (yesDisplayName) {
                size += this.displayName.capacity() + 1;
                if (this.doubleQuoteIt(this.displayName)) {
                    doubleQuoteIt = true;
                    size += 2;
                }
            }
            boolean bl2 = yesAngleQuoteIt = yesDisplayName || this.uriBuilder.hasParameters();
            if (yesAngleQuoteIt) {
                size += 2;
            }
            Buffer addressBuf = Buffers.createBuffer((int)size);
            if (yesDisplayName) {
                if (doubleQuoteIt) {
                    addressBuf.write((byte)34);
                    this.displayName.getBytes(0, addressBuf);
                    addressBuf.write((byte)34);
                } else {
                    this.displayName.getBytes(0, addressBuf);
                }
                addressBuf.write((byte)32);
            }
            if (yesAngleQuoteIt) {
                addressBuf.write((byte)60);
                uriBuffer.getBytes(0, addressBuf);
                addressBuf.write((byte)62);
            } else {
                uriBuffer.getBytes(0, addressBuf);
            }
            return new AddressImpl(addressBuf, this.displayName, uri);
        }

        private boolean doubleQuoteIt(Buffer buffer) {
            try {
                return buffer.indexOf(1024, new byte[]{32, 9}) != -1 && buffer.getByte(0) != 34;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

