/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.eclipse.sisu.reflect.ClassSpace;
import org.eclipse.sisu.reflect.DeferredClass;
import org.eclipse.sisu.reflect.FileEntryIterator;
import org.eclipse.sisu.reflect.NamedClass;
import org.eclipse.sisu.reflect.ResourceEnumeration;
import org.eclipse.sisu.reflect.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLClassSpace
implements ClassSpace {
    private static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    private static final URL[] NO_URLS = new URL[0];
    private static final Enumeration<URL> NO_ENTRIES = Collections.enumeration(Collections.emptySet());
    private static final String[] EMPTY_CLASSPATH = new String[0];
    private final ClassLoader loader;
    private URL[] classPath;

    public URLClassSpace(ClassLoader loader) {
        this.loader = loader;
    }

    public URLClassSpace(ClassLoader loader, URL[] path) {
        this.loader = loader;
        this.classPath = path != null && path.length > 0 ? URLClassSpace.expandClassPath(path) : NO_URLS;
    }

    @Override
    public Class<?> loadClass(String name) {
        try {
            return this.loader.loadClass(name);
        }
        catch (Exception e) {
            throw new TypeNotPresentException(name, e);
        }
        catch (LinkageError e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    @Override
    public DeferredClass<?> deferLoadClass(String name) {
        return new NamedClass(this, name);
    }

    @Override
    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        try {
            Enumeration<URL> resources = this.loader.getResources(name);
            return resources != null ? resources : NO_ENTRIES;
        }
        catch (IOException iOException) {
            return NO_ENTRIES;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String glob, boolean recurse) {
        return new ResourceEnumeration(path, glob, recurse, this.getClassPath());
    }

    public URL[] getURLs() {
        return (URL[])this.getClassPath().clone();
    }

    public int hashCode() {
        return this.loader.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof URLClassSpace) {
            return this.loader.equals(((URLClassSpace)rhs).loader);
        }
        return false;
    }

    public String toString() {
        return this.loader.toString();
    }

    private synchronized URL[] getClassPath() {
        if (this.classPath == null) {
            ClassLoader l = this.loader;
            while (l != null) {
                URL[] path;
                if (l instanceof URLClassLoader && (path = ((URLClassLoader)l).getURLs()) != null && path.length > 0) {
                    this.classPath = URLClassSpace.expandClassPath(path);
                    break;
                }
                l = l.getParent();
            }
            if (this.classPath == null) {
                this.classPath = NO_URLS;
            }
        }
        return this.classPath;
    }

    private static URL[] expandClassPath(URL[] classPath) {
        ArrayList<URL> searchPath = new ArrayList<URL>();
        Collections.addAll(searchPath, classPath);
        ArrayList<URL> expandedPath = new ArrayList<URL>();
        HashSet<String> visited = new HashSet<String>();
        int i = 0;
        while (i < searchPath.size()) {
            block7: {
                URL url = URLClassSpace.normalizeEntry((URL)searchPath.get(i));
                if (url != null && visited.add(url.toString())) {
                    String[] classPathEntries;
                    expandedPath.add(url);
                    try {
                        classPathEntries = URLClassSpace.getClassPathEntries(url);
                    }
                    catch (IOException iOException) {
                        break block7;
                    }
                    String[] stringArray = classPathEntries;
                    int n = classPathEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entry = stringArray[n2];
                        try {
                            searchPath.add(new URL(url, entry));
                        }
                        catch (MalformedURLException malformedURLException) {}
                        ++n2;
                    }
                }
            }
            ++i;
        }
        return expandedPath.toArray(new URL[expandedPath.size()]);
    }

    private static URL normalizeEntry(URL url) {
        String path;
        if (url != null && "jar".equals(url.getProtocol()) && (path = url.getPath()).endsWith("!/")) {
            try {
                return new URL(path.substring(0, path.length() - 2));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return url;
    }

    private static String[] getClassPathEntries(URL url) throws IOException {
        String classPath;
        Manifest manifest;
        if (url.getPath().endsWith("/")) {
            InputStream in = Streams.open(new URL(url, MANIFEST_ENTRY));
            try {
                manifest = new Manifest(in);
            }
            finally {
                in.close();
            }
        }
        if ("file".equals(url.getProtocol())) {
            JarFile jf = new JarFile(FileEntryIterator.toFile(url));
            try {
                manifest = jf.getManifest();
            }
            finally {
                jf.close();
            }
        }
        JarInputStream jin = new JarInputStream(Streams.open(url));
        try {
            manifest = jin.getManifest();
        }
        finally {
            jin.close();
        }
        if (manifest != null && (classPath = manifest.getMainAttributes().getValue("Class-Path")) != null) {
            return classPath.split(" ");
        }
        return EMPTY_CLASSPATH;
    }
}

