/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.maven.shared.utils.cli.AbstractStreamHandler;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.io.IOUtil;

public class StreamPumper
extends AbstractStreamHandler {
    private final BufferedReader in;
    private final StreamConsumer consumer;
    private final PrintWriter out;
    private volatile Exception exception = null;
    private static final int SIZE = 1024;

    public StreamPumper(InputStream in, StreamConsumer consumer) {
        this(in, null, consumer);
    }

    private StreamPumper(InputStream in, PrintWriter writer, StreamConsumer consumer) {
        this.in = new BufferedReader(new InputStreamReader(in), 1024);
        this.out = writer;
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object line = this.in.readLine();
            while (line != null) {
                try {
                    if (this.exception == null) {
                        this.consumeLine((String)line);
                    }
                }
                catch (Exception t) {
                    this.exception = t;
                }
                if (this.out != null) {
                    this.out.println((String)line);
                    this.out.flush();
                }
                line = this.in.readLine();
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
        finally {
            IOUtil.close(this.in);
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.setDone();
                this.notifyAll();
            }
        }
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() {
        IOUtil.close(this.out);
    }

    public Exception getException() {
        return this.exception;
    }

    private void consumeLine(String line) {
        if (this.consumer != null && !this.isDisabled()) {
            this.consumer.consumeLine(line);
        }
    }
}

