/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Relocation;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.validation.ModelValidationResult;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

public class MavenMetadataSource
extends AbstractLogEnabled
implements ArtifactMetadataSource {
    public static final String ROLE_HINT = "maven";
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;
    private RepositoryMetadataManager repositoryMetadataManager;
    private MavenProject superProject;

    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        ResolutionGroup result;
        Artifact pomArtifact;
        MavenProject project = null;
        boolean done = false;
        do {
            pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            if ("system".equals(artifact.getScope())) {
                done = true;
                continue;
            }
            try {
                project = this.mavenProjectBuilder.buildFromRepository(pomArtifact, remoteRepositories, localRepository, true);
            }
            catch (InvalidProjectModelException e) {
                this.getLogger().warn("POM for '" + pomArtifact + "' is invalid. It will be ignored for artifact resolution. Reason: " + e.getMessage());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Reason: " + e.getMessage());
                    ModelValidationResult validationResult = e.getValidationResult();
                    if (validationResult != null) {
                        this.getLogger().debug("\nValidation Errors:");
                        Iterator i = validationResult.getMessages().iterator();
                        while (i.hasNext()) {
                            this.getLogger().debug(i.next().toString());
                        }
                        this.getLogger().debug("\n");
                    }
                }
                project = null;
            }
            catch (ProjectBuildingException e) {
                throw new ArtifactMetadataRetrievalException("Unable to read the metadata file for artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
            }
            if (project != null) {
                Relocation relocation = null;
                DistributionManagement distMgmt = project.getDistributionManagement();
                if (distMgmt != null) {
                    relocation = distMgmt.getRelocation();
                    artifact.setDownloadUrl(distMgmt.getDownloadUrl());
                    pomArtifact.setDownloadUrl(distMgmt.getDownloadUrl());
                }
                if (relocation != null) {
                    if (relocation.getGroupId() != null) {
                        artifact.setGroupId(relocation.getGroupId());
                    }
                    if (relocation.getArtifactId() != null) {
                        artifact.setArtifactId(relocation.getArtifactId());
                    }
                    if (relocation.getVersion() != null) {
                        artifact.setVersionRange(VersionRange.createFromVersion((String)relocation.getVersion()));
                    }
                    if (artifact.getDependencyFilter() != null && !artifact.getDependencyFilter().include(artifact)) {
                        return null;
                    }
                    String message = "\n  This artifact has been relocated to " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ".\n";
                    if (relocation.getMessage() != null) {
                        message = message + "  " + relocation.getMessage() + "\n";
                    }
                    if (artifact.getDependencyTrail() != null && artifact.getDependencyTrail().size() == 1) {
                        this.getLogger().warn("While downloading " + pomArtifact.getGroupId() + ":" + pomArtifact.getArtifactId() + ":" + pomArtifact.getVersion() + message + "\n");
                        continue;
                    }
                    this.getLogger().debug("While downloading " + pomArtifact.getGroupId() + ":" + pomArtifact.getArtifactId() + ":" + pomArtifact.getVersion() + message + "\n");
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        if (artifact.getDownloadUrl() == null) {
            artifact.setDownloadUrl(pomArtifact.getDownloadUrl());
        }
        if (project == null) {
            result = new ResolutionGroup(pomArtifact, Collections.EMPTY_SET, Collections.EMPTY_LIST);
        } else {
            Set artifacts = Collections.EMPTY_SET;
            if (!artifact.getArtifactHandler().isIncludesDependencies()) {
                try {
                    artifacts = project.createArtifacts(this.artifactFactory, artifact.getScope(), artifact.getDependencyFilter());
                }
                catch (InvalidDependencyVersionException e) {
                    throw new ArtifactMetadataRetrievalException("Error in metadata for artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
                }
            }
            List repositories = this.aggregateRepositoryLists(remoteRepositories, project.getRemoteArtifactRepositories());
            result = new ResolutionGroup(pomArtifact, artifacts, repositories);
        }
        return result;
    }

    private List aggregateRepositoryLists(List remoteRepositories, List remoteArtifactRepositories) throws ArtifactMetadataRetrievalException {
        if (this.superProject == null) {
            try {
                this.superProject = this.mavenProjectBuilder.buildStandaloneSuperProject(null);
            }
            catch (ProjectBuildingException e) {
                throw new ArtifactMetadataRetrievalException("Unable to parse the Maven built-in model: " + e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        repositories.addAll(remoteRepositories);
        Iterator it = this.superProject.getRemoteArtifactRepositories().iterator();
        while (it.hasNext()) {
            ArtifactRepository superRepo = (ArtifactRepository)it.next();
            Iterator aggregatedIterator = repositories.iterator();
            while (aggregatedIterator.hasNext()) {
                ArtifactRepository repo = (ArtifactRepository)aggregatedIterator.next();
                if (!repo.getId().equals(superRepo.getId()) || !repo.getUrl().equals(superRepo.getUrl())) continue;
                aggregatedIterator.remove();
            }
        }
        it = remoteArtifactRepositories.iterator();
        while (it.hasNext()) {
            ArtifactRepository repository = (ArtifactRepository)it.next();
            if (repositories.contains(repository)) continue;
            repositories.add(repository);
        }
        return repositories;
    }

    public static Set createArtifacts(ArtifactFactory artifactFactory, List dependencies, String inheritedScope, ArtifactFilter dependencyFilter, MavenProject project) throws InvalidDependencyVersionException {
        LinkedHashSet<Artifact> projectArtifacts = new LinkedHashSet<Artifact>(dependencies.size());
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            VersionRange versionRange;
            Dependency d = (Dependency)i.next();
            String scope = d.getScope();
            if (StringUtils.isEmpty((String)scope)) {
                scope = "compile";
                d.setScope(scope);
            }
            try {
                versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidDependencyVersionException("Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Exception)((Object)e));
            }
            Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), scope, inheritedScope, d.isOptional());
            if ("system".equals(scope)) {
                artifact.setFile(new File(d.getSystemPath()));
            }
            ArtifactFilter artifactFilter = dependencyFilter;
            if (artifact == null || artifactFilter != null && !artifactFilter.include(artifact)) continue;
            if (d.getExclusions() != null && !d.getExclusions().isEmpty()) {
                ArrayList<String> exclusions = new ArrayList<String>();
                Iterator j = d.getExclusions().iterator();
                while (j.hasNext()) {
                    Exclusion e = (Exclusion)j.next();
                    exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
                }
                ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
                if (artifactFilter != null) {
                    AndArtifactFilter filter = new AndArtifactFilter();
                    filter.add(artifactFilter);
                    filter.add((ArtifactFilter)newFilter);
                    artifactFilter = filter;
                } else {
                    artifactFilter = newFilter;
                }
            }
            artifact.setDependencyFilter(artifactFilter);
            if (project != null) {
                artifact = project.replaceWithActiveArtifact(artifact);
            }
            projectArtifacts.add(artifact);
        }
        return projectArtifacts;
    }

    public List retrieveAvailableVersions(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        ArrayList<DefaultArtifactVersion> versions;
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, remoteRepositories, localRepository);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), (Throwable)e);
        }
        Metadata repoMetadata = metadata.getMetadata();
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            List metadataVersions = repoMetadata.getVersioning().getVersions();
            versions = new ArrayList<DefaultArtifactVersion>(metadataVersions.size());
            Iterator i = metadataVersions.iterator();
            while (i.hasNext()) {
                String version = (String)i.next();
                versions.add(new DefaultArtifactVersion(version));
            }
        } else {
            versions = Collections.EMPTY_LIST;
        }
        return versions;
    }
}

