/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.offline.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class OfflineMessageRequest
extends IQ {
    public static final String ELEMENT = "offline";
    public static final String NAMESPACE = "http://jabber.org/protocol/offline";
    private final List<Item> items = new ArrayList<Item>();
    private boolean purge = false;
    private boolean fetch = false;

    public OfflineMessageRequest() {
        super(ELEMENT, NAMESPACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.items));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.rightAngleBracket();
        List<Item> list = this.items;
        synchronized (list) {
            for (Item item : this.items) {
                buf.append((CharSequence)item.toXML());
            }
        }
        if (this.purge) {
            buf.append((CharSequence)"<purge/>");
        }
        if (this.fetch) {
            buf.append((CharSequence)"<fetch/>");
        }
        return buf;
    }

    public static class Provider
    extends IQProvider<OfflineMessageRequest> {
        public OfflineMessageRequest parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
            OfflineMessageRequest request = new OfflineMessageRequest();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT) {
                    if (parser.getName().equals("item")) {
                        request.addItem(Provider.parseItem(parser));
                        continue;
                    }
                    if (parser.getName().equals("purge")) {
                        request.setPurge(true);
                        continue;
                    }
                    if (!parser.getName().equals("fetch")) continue;
                    request.setFetch(true);
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals(OfflineMessageRequest.ELEMENT)) continue;
                done = true;
            }
            return request;
        }

        private static Item parseItem(XmlPullParser parser) throws XmlPullParserException, IOException {
            boolean done = false;
            Item item = new Item(parser.getAttributeValue("", "node"));
            item.setAction(parser.getAttributeValue("", "action"));
            item.setJid(parser.getAttributeValue("", "jid"));
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("item")) continue;
                done = true;
            }
            return item;
        }
    }

    public static class Item {
        private String action;
        private String jid;
        private String node;

        public Item(String node) {
            this.node = node;
        }

        public String getNode() {
            return this.node;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<item");
            if (this.getAction() != null) {
                buf.append(" action=\"").append(this.getAction()).append('\"');
            }
            if (this.getJid() != null) {
                buf.append(" jid=\"").append(this.getJid()).append('\"');
            }
            if (this.getNode() != null) {
                buf.append(" node=\"").append(this.getNode()).append('\"');
            }
            buf.append("/>");
            return buf.toString();
        }
    }
}

