/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.bookmarkautojoin;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bookmarks.BookmarkManager;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jxmpp.jid.parts.Resourcepart;

public final class MucBookmarkAutojoinManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(MucBookmarkAutojoinManager.class.getName());
    private static final Map<XMPPConnection, MucBookmarkAutojoinManager> INSTANCES = new WeakHashMap<XMPPConnection, MucBookmarkAutojoinManager>();
    private static boolean autojoinEnabledDefault = false;
    private final MultiUserChatManager multiUserChatManager;
    private final BookmarkManager bookmarkManager;
    private boolean autojoinEnabled = autojoinEnabledDefault;

    public static void setAutojoinPerDefault(boolean autojoin) {
        autojoinEnabledDefault = autojoin;
    }

    public static synchronized MucBookmarkAutojoinManager getInstanceFor(XMPPConnection connection) {
        MucBookmarkAutojoinManager mbam = INSTANCES.get(connection);
        if (mbam == null) {
            mbam = new MucBookmarkAutojoinManager(connection);
            INSTANCES.put(connection, mbam);
        }
        return mbam;
    }

    private MucBookmarkAutojoinManager(XMPPConnection connection) {
        super(connection);
        this.multiUserChatManager = MultiUserChatManager.getInstanceFor(connection);
        this.bookmarkManager = BookmarkManager.getBookmarkManager(connection);
        connection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (!MucBookmarkAutojoinManager.this.autojoinEnabled) {
                    return;
                }
                MucBookmarkAutojoinManager.this.autojoinBookmarkedConferences();
            }
        });
    }

    public void setAutojoinEnabled(boolean autojoin) {
        this.autojoinEnabled = autojoin;
    }

    public void autojoinBookmarkedConferences() {
        List<BookmarkedConference> bookmarkedConferences;
        try {
            bookmarkedConferences = this.bookmarkManager.getBookmarkedConferences();
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            LOGGER.log(Level.FINER, "Could not get MUC bookmarks", e);
            return;
        }
        catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
            LOGGER.log(Level.WARNING, "Could not get MUC bookmarks", e);
            return;
        }
        XMPPConnection connection = this.connection();
        Resourcepart defaultNick = connection.getUser().getResourcepart();
        for (BookmarkedConference bookmarkedConference : bookmarkedConferences) {
            if (!bookmarkedConference.isAutoJoin()) continue;
            Resourcepart nick = bookmarkedConference.getNickname();
            if (nick == null) {
                nick = defaultNick;
            }
            String password = bookmarkedConference.getPassword();
            MultiUserChat muc = this.multiUserChatManager.getMultiUserChat(bookmarkedConference.getJid());
            try {
                MultiUserChat.MucCreateConfigFormHandle handle = muc.createOrJoinIfNecessary(nick, password);
                if (handle == null) continue;
                handle.makeInstant();
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                LOGGER.log(Level.FINER, "Could not autojoin bookmarked MUC", e);
                break;
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException | MultiUserChatException.NotAMucServiceException e) {
                LOGGER.log(Level.WARNING, "Could not autojoin bookmarked MUC", (Throwable)e);
            }
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                MucBookmarkAutojoinManager.getInstanceFor(connection);
            }
        });
    }
}

