/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.buffer;

import io.pkts.buffer.AbstractBuffer;
import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.buffer.WriteNotSupportedException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;

public final class ByteBuffer
extends AbstractBuffer {
    protected final byte[] buffer;

    protected ByteBuffer(byte[] buffer) {
        this(0, 0, buffer.length, buffer);
    }

    protected ByteBuffer(int readerIndex, int lowerBoundary, int upperBoundary, byte[] buffer) {
        this(readerIndex, lowerBoundary, upperBoundary, upperBoundary, buffer);
    }

    protected ByteBuffer(int readerIndex, int lowerBoundary, int upperBoundary, int writerIndex, byte[] buffer) {
        super(readerIndex, lowerBoundary, upperBoundary, writerIndex);
        assert (buffer != null);
        this.buffer = buffer;
    }

    @Override
    public Buffer slice(int start, int stop) {
        int upperBoundary;
        if (start == stop) {
            return Buffers.EMPTY_BUFFER;
        }
        this.checkIndex(this.lowerBoundary + start);
        this.checkIndex(this.lowerBoundary + stop - 1);
        int writerIndex = upperBoundary = this.lowerBoundary + stop;
        return new ByteBuffer(0, this.lowerBoundary + start, upperBoundary, writerIndex, this.buffer);
    }

    @Override
    public Buffer readBytes(int length) throws IndexOutOfBoundsException {
        int upperBoundary;
        if (length == 0) {
            return Buffers.EMPTY_BUFFER;
        }
        this.checkReadableBytes(length);
        int lowerBoundary = this.readerIndex + this.lowerBoundary;
        this.readerIndex += length;
        int writerIndex = upperBoundary = this.readerIndex + this.lowerBoundary;
        return new ByteBuffer(0, lowerBoundary, upperBoundary, writerIndex, this.buffer);
    }

    @Override
    public boolean hasReadableBytes() {
        return this.getReadableBytes() > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getReadableBytes() == 0;
    }

    @Override
    public byte getByte(int index) throws IndexOutOfBoundsException {
        this.checkIndex(this.lowerBoundary + index);
        return this.buffer[this.lowerBoundary + index];
    }

    @Override
    public void write(byte b) throws IndexOutOfBoundsException {
        this.checkWriterIndex(this.writerIndex);
        this.buffer[this.lowerBoundary + this.writerIndex] = b;
        ++this.writerIndex;
    }

    @Override
    public void write(byte[] bytes) throws IndexOutOfBoundsException {
        if (!this.checkWritableBytesSafe(bytes.length)) {
            throw new IndexOutOfBoundsException("Unable to write the entire String to this buffer. Nothing was written");
        }
        System.arraycopy(bytes, 0, this.buffer, this.writerIndex, bytes.length);
        this.writerIndex += bytes.length;
    }

    @Override
    public byte[] getArray() {
        int length = this.getReadableBytes();
        byte[] array = new byte[length];
        System.arraycopy(this.buffer, this.lowerBoundary + this.readerIndex, array, 0, length);
        return array;
    }

    @Override
    public byte[] getRawArray() {
        return this.buffer;
    }

    @Override
    public byte readByte() throws IndexOutOfBoundsException {
        return this.getByte(this.readerIndex++);
    }

    @Override
    public byte peekByte() throws IndexOutOfBoundsException, IOException {
        return this.getByte(this.readerIndex);
    }

    public long unsignedInt(byte a, byte b, byte c, byte d) {
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
    }

    @Override
    public long readUnsignedInt() throws IndexOutOfBoundsException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public int readInt() throws IndexOutOfBoundsException {
        int value = this.getInt(this.readerIndex);
        this.readerIndex += 4;
        return value;
    }

    @Override
    public short readShort() throws IndexOutOfBoundsException {
        short value = this.getShort(this.readerIndex);
        this.readerIndex += 2;
        return value;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int getInt(int index) {
        int i = this.lowerBoundary + index;
        this.checkIndex(i);
        this.checkIndex(i + 3);
        return (this.buffer[i] & 0xFF) << 24 | (this.buffer[i + 1] & 0xFF) << 16 | (this.buffer[i + 2] & 0xFF) << 8 | (this.buffer[i + 3] & 0xFF) << 0;
    }

    @Override
    public short getShort(int index) {
        int i = this.lowerBoundary + index;
        this.checkIndex(i);
        this.checkIndex(i + 1);
        return (short)(this.buffer[i] << 8 | this.buffer[i + 1] & 0xFF);
    }

    @Override
    public void setUnsignedShort(int index, int value) {
        int i = this.lowerBoundary + index;
        this.checkIndex(i);
        this.checkIndex(i + 1);
        this.buffer[i] = (byte)(value >> 8);
        this.buffer[i + 1] = (byte)value;
    }

    @Override
    public int getUnsignedShort(int index) throws IndexOutOfBoundsException {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public short getUnsignedByte(int index) throws IndexOutOfBoundsException {
        return (short)(this.getByte(index) & 0xFF);
    }

    @Override
    public String dumpAsHex() {
        return "dumpAsHex isn't implemented just yet";
    }

    @Override
    public Buffer clone() {
        int size = this.capacity();
        byte[] copy = new byte[size];
        System.arraycopy(this.buffer, this.lowerBoundary, copy, 0, size);
        return new ByteBuffer(copy);
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = this.lowerBoundary + this.readerIndex; i < this.upperBoundary; ++i) {
            result = 31 * result + this.buffer[i];
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.internalEquals(false, other);
    }

    @Override
    public boolean equalsIgnoreCase(Object other) {
        return this.internalEquals(true, other);
    }

    private boolean internalEquals(boolean ignoreCase, Object other) {
        try {
            if (this == other) {
                return true;
            }
            ByteBuffer b = (ByteBuffer)other;
            if (this.getReadableBytes() != b.getReadableBytes()) {
                return false;
            }
            int length = this.getReadableBytes();
            for (int i = 0; i < length; ++i) {
                byte a1 = this.buffer[this.lowerBoundary + i];
                byte b1 = b.buffer[b.lowerBoundary + i];
                if (a1 == b1 || ignoreCase && (a1 >= 65 && a1 <= 90 || a1 >= 97 && a1 <= 122) && (b1 >= 65 && b1 <= 90 || b1 >= 97 && b1 <= 122) && (a1 & 0x1F) == (b1 & 0x1F)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    @Override
    public void setByte(int index, byte value) throws IndexOutOfBoundsException {
        int i = this.lowerBoundary + index;
        this.checkIndex(i);
        this.buffer[i] = value;
    }

    @Override
    public void setUnsignedByte(int index, short value) throws IndexOutOfBoundsException {
        int i = this.lowerBoundary + index;
        this.checkIndex(i);
        this.buffer[this.lowerBoundary + index] = (byte)value;
    }

    @Override
    public String toString() {
        try {
            return new String(this.getArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void getBytes(Buffer dst) {
        this.getBytes(this.getReaderIndex(), dst);
    }

    @Override
    public void getBytes(int index, Buffer dst) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index less than zero");
        }
        int max = dst.getWritableBytes();
        int stop = Math.min(this.lowerBoundary + index + max, this.writerIndex);
        for (int i = this.lowerBoundary + index; i < stop; ++i) {
            dst.write(this.buffer[i]);
        }
    }

    @Override
    public void getBytes(byte[] dst) throws IndexOutOfBoundsException {
        int length = Math.min(dst.length, this.getReadableBytes());
        System.arraycopy(this.buffer, this.lowerBoundary + this.readerIndex, dst, 0, length);
    }

    public void getBytes(int index, java.nio.ByteBuffer dst) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index less than zero");
        }
        int stop = this.lowerBoundary + index;
        for (int i = stop - 1; i >= this.lowerBoundary + index; --i) {
            dst.put(this.buffer[i]);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.buffer, this.lowerBoundary, this.writerIndex - this.lowerBoundary);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public boolean hasWriteSupport() {
        return true;
    }

    @Override
    public void write(String s) throws IndexOutOfBoundsException, WriteNotSupportedException, UnsupportedEncodingException {
        this.write(s, "UTF-8");
    }

    @Override
    public void write(String s, String charset) throws IndexOutOfBoundsException, WriteNotSupportedException, UnsupportedEncodingException {
        byte[] bytes = s.getBytes(charset);
        if (!this.checkWritableBytesSafe(bytes.length)) {
            throw new IndexOutOfBoundsException("Unable to write the entire String to this buffer. Nothing was written");
        }
        System.arraycopy(bytes, 0, this.buffer, this.writerIndex, bytes.length);
        this.writerIndex += bytes.length;
    }

    @Override
    public void setInt(int index, int value) throws IndexOutOfBoundsException {
        this.checkIndex(index);
        this.checkIndex(index + 3);
        this.buffer[this.lowerBoundary + index + 0] = (byte)(value >>> 24);
        this.buffer[this.lowerBoundary + index + 1] = (byte)(value >>> 16);
        this.buffer[this.lowerBoundary + index + 2] = (byte)(value >>> 8);
        this.buffer[this.lowerBoundary + index + 3] = (byte)value;
    }

    @Override
    public void setUnsignedInt(int index, long value) throws IndexOutOfBoundsException {
        this.checkIndex(index);
        this.checkIndex(index + 3);
        this.buffer[this.lowerBoundary + index + 0] = (byte)value;
        this.buffer[this.lowerBoundary + index + 1] = (byte)(value >>> 8);
        this.buffer[this.lowerBoundary + index + 2] = (byte)(value >>> 16);
        this.buffer[this.lowerBoundary + index + 3] = (byte)(value >>> 24);
    }

    @Override
    public void write(int value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        if (!this.checkWritableBytesSafe(4)) {
            throw new IndexOutOfBoundsException("Unable to write the entire String to this buffer. Nothing was written");
        }
        int index = this.lowerBoundary + this.writerIndex;
        this.buffer[index + 0] = (byte)(value >>> 24);
        this.buffer[index + 1] = (byte)(value >>> 16);
        this.buffer[index + 2] = (byte)(value >>> 8);
        this.buffer[index + 3] = (byte)value;
        this.writerIndex += 4;
    }

    @Override
    public void write(long value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        if (!this.checkWritableBytesSafe(8)) {
            throw new IndexOutOfBoundsException("Unable to write the entire String to this buffer. Nothing was written");
        }
        int index = this.lowerBoundary + this.writerIndex;
        this.buffer[index + 0] = (byte)(value >>> 56);
        this.buffer[index + 1] = (byte)(value >>> 48);
        this.buffer[index + 2] = (byte)(value >>> 40);
        this.buffer[index + 3] = (byte)(value >>> 32);
        this.buffer[index + 4] = (byte)(value >>> 24);
        this.buffer[index + 5] = (byte)(value >>> 16);
        this.buffer[index + 6] = (byte)(value >>> 8);
        this.buffer[index + 7] = (byte)value;
        this.writerIndex += 8;
    }

    @Override
    public void writeAsString(int value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        int size;
        int n = size = value < 0 ? Buffers.stringSize(-value) + 1 : Buffers.stringSize(value);
        if (!this.checkWritableBytesSafe(size)) {
            throw new IndexOutOfBoundsException();
        }
        Buffers.getBytes(value, this.lowerBoundary + this.writerIndex + size, this.buffer);
        this.writerIndex += size;
    }

    @Override
    public void writeAsString(long value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        int size;
        int n = size = value < 0L ? Buffers.stringSize(-value) + 1 : Buffers.stringSize(value);
        if (!this.checkWritableBytesSafe(size)) {
            throw new IndexOutOfBoundsException();
        }
        Buffers.getBytes(value, this.lowerBoundary + this.writerIndex + size, this.buffer);
        this.writerIndex += size;
    }
}

