/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.buffer;

import io.pkts.buffer.BoundedInputStreamBuffer;
import io.pkts.buffer.Buffer;
import io.pkts.buffer.ByteBuffer;
import io.pkts.buffer.EmptyBuffer;
import java.io.InputStream;
import java.nio.charset.Charset;

public final class Buffers {
    private static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    public static Buffer EMPTY_BUFFER = new EmptyBuffer();

    private Buffers() {
    }

    public static Buffer wrap(int value) {
        int size = value < 0 ? Buffers.stringSize(-value) + 1 : Buffers.stringSize(value);
        byte[] bytes = new byte[size];
        Buffers.getBytes(value, size, bytes);
        return new ByteBuffer(bytes);
    }

    public static Buffer wrap(long value) {
        int size = value < 0L ? Buffers.stringSize(-value) + 1 : Buffers.stringSize(value);
        byte[] bytes = new byte[size];
        Buffers.getBytes(value, size, bytes);
        return new ByteBuffer(bytes);
    }

    public static Buffer wrap(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        if (s.isEmpty()) {
            return EMPTY_BUFFER;
        }
        return Buffers.wrap(s.getBytes(Charset.forName("UTF-8")));
    }

    public static Buffer wrap(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("the input stream cannot be null or empty");
        }
        return new BoundedInputStreamBuffer(is);
    }

    public static Buffer createBuffer(int capacity) {
        byte[] buffer = new byte[capacity];
        return new ByteBuffer(0, 0, buffer.length, 0, buffer);
    }

    public static Buffer wrap(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            throw new IllegalArgumentException("the buffer cannot be null or empty");
        }
        return new ByteBuffer(buffer);
    }

    public static Buffer wrapAndClone(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            throw new IllegalArgumentException("the buffer cannot be null or empty");
        }
        byte[] b = new byte[buffer.length];
        System.arraycopy(buffer, 0, b, 0, buffer.length);
        return new ByteBuffer(b);
    }

    public static Buffer wrap(Buffer one, Buffer two) {
        int size2;
        int size1 = one != null ? one.getReadableBytes() : 0;
        int n = size2 = two != null ? two.getReadableBytes() : 0;
        if (size1 == 0 && size2 > 0) {
            return two.slice();
        }
        if (size2 == 0 && size1 > 0) {
            return one.slice();
        }
        if (size2 == 0 && size1 == 0) {
            return EMPTY_BUFFER;
        }
        Buffer composite = Buffers.createBuffer(size1 + size2);
        one.getBytes(composite);
        two.getBytes(composite);
        return composite;
    }

    public static Buffer wrap(byte[] buffer, int lowerBoundary, int upperBoundary) {
        if (buffer == null || buffer.length == 0) {
            throw new IllegalArgumentException("the buffer cannot be null or empty");
        }
        if (upperBoundary > buffer.length) {
            throw new IllegalArgumentException("The upper boundary cannot exceed the length of the buffer");
        }
        if (lowerBoundary >= upperBoundary) {
            throw new IllegalArgumentException("The lower boundary must be lower than the upper boundary");
        }
        if (lowerBoundary < 0) {
            throw new IllegalArgumentException("The lower boundary must be a equal or greater than zero");
        }
        boolean readerIndex = false;
        int writerIndex = upperBoundary;
        return new ByteBuffer(0, lowerBoundary, upperBoundary, writerIndex, buffer);
    }

    public static void getBytes(int i, int index, byte[] buf) {
        int r;
        int q;
        int charPos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static int stringSizeOf(int value) {
        return value < 0 ? Buffers.stringSize(-value) + 1 : Buffers.stringSize(value);
    }

    public static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static void getBytes(long i, int index, byte[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = (byte)sign;
        }
    }

    public static int stringSizeOf(long value) {
        return value < 0L ? Buffers.stringSize(-value) + 1 : Buffers.stringSize(value);
    }

    public static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }
}

