/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.DataModelHelperImpl;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.felix.obrplugin.ObrUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObrIndex
extends AbstractMojo {
    private String obrRepository;
    private String urlTemplate;
    private String mavenRepository;
    private ArtifactRepository localRepository;
    private final FileFilter filter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.getName().endsWith("ar");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        try {
            log.info((CharSequence)"Indexing...");
            String repo = this.mavenRepository;
            if (repo == null) {
                repo = this.localRepository.getBasedir();
            }
            URI mavenRepoUri = new File(repo).toURI();
            URI repositoryXml = ObrUtils.findRepositoryXml(repo, this.obrRepository);
            log.info((CharSequence)("Repository:   " + mavenRepoUri));
            log.info((CharSequence)("OBR xml:      " + repositoryXml));
            log.info((CharSequence)("URL template: " + this.urlTemplate));
            ArrayList<File> files = new ArrayList<File>();
            this.findAllJars(new File(repo), files);
            DataModelHelperImpl dmh = new DataModelHelperImpl();
            File obrRepoFile = new File(repositoryXml);
            RepositoryImpl repository = obrRepoFile.isFile() ? (RepositoryImpl)dmh.repository(repositoryXml.toURL()) : new RepositoryImpl();
            for (File file : files) {
                try {
                    ResourceImpl resource = (ResourceImpl)dmh.createResource(file.toURI().toURL());
                    if (resource != null) {
                        repository.addResource((Resource)resource);
                        this.doTemplate(mavenRepoUri, file, resource);
                        log.info((CharSequence)("Adding resource: " + file));
                        continue;
                    }
                    log.info((CharSequence)("Ignoring non OSGi bundle: " + file));
                }
                catch (Exception e) {
                    log.warn((CharSequence)("Error processing bundle: " + file + " " + e.getMessage()));
                }
            }
            FileWriter writer = new FileWriter(obrRepoFile);
            try {
                dmh.writeRepository((Repository)repository, (Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Exception while updating local OBR: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    protected void doTemplate(URI root, File path, ResourceImpl resource) throws IOException, URISyntaxException {
        path = path.getAbsoluteFile().getCanonicalFile();
        String finalUri = root.relativize(path.toURI()).toString();
        if ("maven".equals(this.urlTemplate)) {
            String dir = root.relativize(path.toURI()).toString();
            String[] p = dir.split("/");
            if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
                String artifactId = p[p.length - 3];
                String version = p[p.length - 2];
                String artifactIdVersion = artifactId + "-" + version;
                StringBuffer sb = new StringBuffer();
                String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
                String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
                sb.append("mvn:");
                for (int j = 0; j < p.length - 3; ++j) {
                    if (j > 0) {
                        sb.append('.');
                    }
                    sb.append(p[j]);
                }
                sb.append('/').append(artifactId).append('/').append(version);
                if (!"jar".equals(type) || classifier != null) {
                    sb.append('/');
                    if (!"jar".equals(type)) {
                        sb.append(type);
                    }
                    if (classifier != null) {
                        sb.append('/').append(classifier);
                    }
                }
                finalUri = sb.toString();
            }
        } else if (this.urlTemplate != null) {
            String dir = path.getParentFile().toURI().toURL().toString();
            if (dir.endsWith("/")) {
                dir = dir.substring(0, dir.length() - 1);
            }
            if (dir.startsWith(root.toString())) {
                dir = dir.substring(root.toString().length());
            }
            String url = this.urlTemplate.replaceAll("%v", "" + resource.getVersion());
            url = url.replaceAll("%s", resource.getSymbolicName());
            url = url.replaceAll("%f", path.getName());
            finalUri = url = url.replaceAll("%p", dir);
        }
        resource.put("uri", finalUri, "uri");
    }

    private void findAllJars(File mainRoot, List<File> files) {
        ArrayList<File> roots = new ArrayList<File>();
        roots.add(mainRoot);
        while (!roots.isEmpty()) {
            File root = (File)roots.remove(0);
            File[] children = root.listFiles();
            if (children == null) continue;
            for (File child : children) {
                if (child.isFile() && this.filter.accept(child)) {
                    files.add(child);
                    continue;
                }
                if (!child.isDirectory()) continue;
                roots.add(child);
            }
        }
    }
}

