/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.site.AbstractStagingMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="stage-deploy", requiresDependencyResolution=ResolutionScope.TEST)
public class SiteStageDeployMojo
extends AbstractStagingMojo {
    @Parameter(property="stagingSiteURL")
    private String stagingSiteURL;
    @Parameter(property="stagingRepositoryId")
    private String stagingRepositoryId;

    protected boolean isDeploy() {
        return true;
    }

    protected String determineTopDistributionManagementSiteUrl() throws MojoExecutionException {
        if (StringUtils.isNotEmpty((String)this.topSiteURL)) {
            return this.topSiteURL;
        }
        if (StringUtils.isNotEmpty((String)this.stagingSiteURL)) {
            return SiteStageDeployMojo.getSite(this.getTopMostParentWithSameStagingSiteURL(this.project)).getUrl();
        }
        return super.determineTopDistributionManagementSiteUrl();
    }

    protected Site determineDeploySite() throws MojoExecutionException {
        Site top = new Site();
        top.setId(this.stagingRepoId());
        this.getLog().info((CharSequence)("Using this server ID for stage deploy: " + top.getId()));
        String stagingURL = this.determineStageDeploySiteURL();
        this.getLog().info((CharSequence)("Using this base URL for stage deploy: " + stagingURL));
        top.setUrl(stagingURL);
        return top;
    }

    private MavenProject getTopMostParentWithSameStagingSiteURL(MavenProject project) {
        String actualStagingSiteURL = this.getStagingSiteURL(project);
        MavenProject parent = project;
        while (parent != null && actualStagingSiteURL.equals(this.getStagingSiteURL(parent))) {
            project = parent;
            parent = this.siteTool.getParentProject(parent, this.reactorProjects, this.localRepository);
        }
        return project;
    }

    private String getStagingSiteURL(MavenProject project) {
        String sitePluginKey = "org.apache.maven.plugins:maven-site-plugin";
        if (project == null) {
            return null;
        }
        Build build = project.getBuild();
        if (build == null) {
            return null;
        }
        Map plugins = build.getPluginsAsMap();
        Plugin sitePlugin = (Plugin)plugins.get("org.apache.maven.plugins:maven-site-plugin");
        if (sitePlugin == null) {
            PluginManagement buildPluginManagement = build.getPluginManagement();
            if (buildPluginManagement == null) {
                return null;
            }
            plugins = buildPluginManagement.getPluginsAsMap();
            sitePlugin = (Plugin)plugins.get("org.apache.maven.plugins:maven-site-plugin");
        }
        if (sitePlugin == null) {
            return null;
        }
        Xpp3Dom sitePluginConfiguration = (Xpp3Dom)sitePlugin.getConfiguration();
        if (sitePluginConfiguration == null) {
            return null;
        }
        Xpp3Dom child = sitePluginConfiguration.getChild("stagingSiteURL");
        if (child == null) {
            return null;
        }
        return child.getValue();
    }

    private String determineStageDeploySiteURL() throws MojoExecutionException {
        if (this.stagingSiteURL != null) {
            this.getLog().debug((CharSequence)("stagingSiteURL specified by the user: " + this.stagingSiteURL));
            return this.stagingSiteURL;
        }
        String defaultStagingSiteURL = SiteStageDeployMojo.appendSlash(this.getTopDistributionManagementSiteUrl()) + "staging/";
        this.getLog().debug((CharSequence)("stagingSiteURL NOT specified, using the top level project: " + defaultStagingSiteURL));
        return defaultStagingSiteURL;
    }

    private String stagingRepoId() {
        if (this.stagingRepositoryId != null) {
            return this.stagingRepositoryId;
        }
        try {
            return SiteStageDeployMojo.getSite(this.project).getId();
        }
        catch (MojoExecutionException ex) {
            return "stagingSite";
        }
    }
}

