/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import javax.inject.Named;
import javax.inject.Provider;

@Named
public class ObjectMapperProvider
implements Provider<ObjectMapper> {
    private final ObjectMapper mapper;

    public ObjectMapperProvider() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().with((AnnotationIntrospector)new JacksonAnnotationIntrospector());
        mapper.getSerializationConfig().with((AnnotationIntrospector)new JacksonAnnotationIntrospector()).withSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.mapper = mapper;
    }

    public ObjectMapper get() {
        return this.mapper;
    }
}

