/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import bsh.EvalError;
import bsh.Interpreter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;

@Mojo(name="bsh-property", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class BeanshellPropertyMojo
extends AbstractDefinePropertyMojo {
    @Parameter(required=true)
    private String source;
    @Parameter
    private String[] properties;
    @Parameter(readonly=true, defaultValue="${session}")
    private MavenSession mavenSession;
    @Parameter(readonly=true, defaultValue="${settings}")
    private Settings settings;

    public void execute() throws MojoFailureException {
        Interpreter interpreter = new Interpreter();
        this.set(interpreter, "project", this.getProject());
        this.set(interpreter, "session", this.mavenSession);
        this.set(interpreter, "settings", this.settings);
        try {
            interpreter.eval(this.source);
        }
        catch (EvalError ee) {
            MojoFailureException mfe = new MojoFailureException("error during Beanshell script execution: " + ee.getMessage());
            mfe.initCause((Throwable)ee);
            throw mfe;
        }
        if (this.properties != null) {
            for (String property : this.properties) {
                try {
                    Object value = interpreter.get(property);
                    if (value == null) continue;
                    this.defineProperty(property, value.toString());
                }
                catch (EvalError ee) {
                    MojoFailureException mfe = new MojoFailureException("cannot get Beanshell global variable '" + property + "': " + ee.getMessage());
                    mfe.initCause((Throwable)ee);
                    throw mfe;
                }
            }
        }
    }

    private void set(Interpreter interpreter, String name, Object value) throws MojoFailureException {
        try {
            interpreter.set(name, value);
        }
        catch (EvalError ee) {
            MojoFailureException mfe = new MojoFailureException("cannot define Beanshell global variable '" + name + "': " + ee.getMessage());
            mfe.initCause((Throwable)ee);
            throw mfe;
        }
    }
}

