/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChecksumUtils {
    private ChecksumUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File checksumFile) throws IOException {
        String checksum;
        block11: {
            checksum = "";
            FileInputStream fis = new FileInputStream(checksumFile);
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                do {
                    if ((line = br.readLine()) != null) continue;
                    break block11;
                } while ((line = line.trim()).length() <= 0);
                checksum = line;
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        if (checksum.matches(".+= [0-9A-Fa-f]+")) {
            int lastSpacePos = checksum.lastIndexOf(32);
            checksum = checksum.substring(lastSpacePos + 1);
        } else {
            int spacePos = checksum.indexOf(32);
            if (spacePos != -1) {
                checksum = checksum.substring(0, spacePos);
            }
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> calc(File dataFile, Collection<String> algos) throws IOException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, MessageDigest> digests = new LinkedHashMap<String, MessageDigest>();
        for (String algo : algos) {
            try {
                digests.put(algo, MessageDigest.getInstance(algo));
            }
            catch (NoSuchAlgorithmException e) {
                results.put(algo, e);
            }
        }
        FileInputStream fis = new FileInputStream(dataFile);
        FileChannel in = fis.getChannel();
        try {
            ByteBuffer bytebuffer = ByteBuffer.allocate(16384);
            while (in.read(bytebuffer) >= 0 || bytebuffer.position() != 0) {
                for (MessageDigest digest : digests.values()) {
                    bytebuffer.flip();
                    digest.update(bytebuffer);
                }
                bytebuffer.compact();
            }
        }
        finally {
            fis.close();
            in.close();
        }
        for (Map.Entry entry : digests.entrySet()) {
            byte[] bytes = ((MessageDigest)entry.getValue()).digest();
            StringBuilder buffer = new StringBuilder(64);
            for (int i = 0; i < bytes.length; ++i) {
                int b = bytes[i] & 0xFF;
                if (b < 16) {
                    buffer.append('0');
                }
                buffer.append(Integer.toHexString(b));
            }
            results.put((String)entry.getKey(), buffer.toString());
        }
        return results;
    }
}

