/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest.xstream.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.AbstractPullReader;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.sonatype.plexus.rest.xstream.LookAheadStreamReader;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LookAheadXppReader
extends AbstractPullReader
implements LookAheadStreamReader {
    private final XmlPullParser parser;
    private final BufferedReader reader;
    private LinkedList<ReadEvent> queue = new LinkedList();
    private ReadEvent currentReadEvent = null;
    HashMap<String, String> lookaheadMap = new HashMap();

    public LookAheadXppReader(Reader reader, XmlFriendlyReplacer replacer) {
        super(replacer);
        try {
            this.parser = this.createParser();
            this.reader = new BufferedReader(reader);
            this.parser.setInput((Reader)this.reader);
            this.moveDown();
        }
        catch (XmlPullParserException e) {
            throw new StreamException((Throwable)e);
        }
    }

    protected XmlPullParser createParser() {
        return new MXParser();
    }

    protected int pullNextEvent() {
        try {
            int eventType;
            if (this.queue.isEmpty()) {
                eventType = this.parser.next();
                this.currentReadEvent = this.createReadEventFromCurrentParserPosition(eventType);
            } else {
                this.currentReadEvent = this.queue.remove();
                eventType = this.currentReadEvent.type;
            }
            switch (eventType) {
                case 0: 
                case 2: {
                    return 1;
                }
                case 1: 
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 9: {
                    return 4;
                }
            }
            return 0;
        }
        catch (XmlPullParserException e) {
            throw new StreamException((Throwable)e);
        }
        catch (IOException e) {
            throw new StreamException((Throwable)e);
        }
    }

    @Override
    public String getFieldValue(String field) {
        if (this.queue.isEmpty()) {
            String node = "";
            String nodeValue = "";
            int eventType = 0;
            do {
                try {
                    eventType = this.parser.next();
                }
                catch (Exception e) {
                    throw new ConversionException(e.getMessage(), (Throwable)e);
                }
                if (eventType == 2) {
                    node = this.parser.getName();
                } else if (eventType == 3) {
                    this.lookaheadMap.put(node, nodeValue);
                    node = null;
                } else if (eventType == 4) {
                    nodeValue = this.parser.getText();
                }
                ReadEvent item = this.createReadEventFromCurrentParserPosition(eventType);
                this.queue.add(item);
            } while (eventType != 1);
        }
        return this.lookaheadMap.get(field);
    }

    private ReadEvent createReadEventFromCurrentParserPosition(int eventType) {
        ReadEvent item = new ReadEvent();
        item.type = eventType;
        item.name = this.parser.getName();
        item.text = this.parser.getText();
        for (int ii = 0; ii < this.parser.getAttributeCount(); ++ii) {
            String attributeName = this.parser.getAttributeName(ii);
            String attributeValue = this.parser.getAttributeValue(ii);
            item.attributes.put(this.unescapeXmlName(attributeName), attributeValue);
        }
        return item;
    }

    protected String pullElementName() {
        return this.currentReadEvent.name;
    }

    protected String pullText() {
        return this.currentReadEvent.text;
    }

    public String getAttribute(String name) {
        return this.currentReadEvent.attributes.get(name);
    }

    public String getAttribute(int index) {
        return this.currentReadEvent.attributes.get(this.getAttributeName(index));
    }

    public int getAttributeCount() {
        return this.currentReadEvent.attributes.size();
    }

    public String getAttributeName(int index) {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>();
        Iterator<Map.Entry<String, String>> iterator = this.currentReadEvent.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            entries.add(iterator.next());
        }
        return (String)((Map.Entry)entries.get(index)).getValue();
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("line number", String.valueOf(this.parser.getLineNumber()));
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new StreamException((Throwable)e);
        }
    }

    class ReadEvent {
        int type;
        String text;
        String name;
        LinkedHashMap<String, String> attributes = new LinkedHashMap();

        ReadEvent() {
        }
    }
}

