/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.http.HttpHeaders;
import io.ktor.http.cio.CIOMultipartDataBase;
import io.ktor.http.content.MultiPartData;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationCallKt;
import io.ktor.server.engine.BlockingBridgeKt;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.jvm.javaio.BlockingKt;
import io.ktor.utils.io.streams.StreamsKt;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a+\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0007H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u001e\u0010\f\u001a\u00020\r*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"checkSafeParking", "", "receiveGuardedInputStream", "Ljava/io/InputStream;", "channel", "Lio/ktor/utils/io/ByteReadChannel;", "defaultPlatformTransformations", "", "Lio/ktor/util/pipeline/PipelineContext;", "Lio/ktor/server/application/ApplicationCall;", "query", "(Lio/ktor/util/pipeline/PipelineContext;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "multiPartData", "Lio/ktor/http/content/MultiPartData;", "rc", "readTextWithCustomCharset", "", "Lio/ktor/utils/io/core/ByteReadPacket;", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "ktor-server-host-common"})
public final class DefaultTransformJvmKt {
    @Nullable
    public static final Object defaultPlatformTransformations(@NotNull PipelineContext<Object, ApplicationCall> $this$defaultPlatformTransformations, @NotNull Object query, @NotNull Continuation<Object> $completion) {
        ByteReadChannel byteReadChannel = query instanceof ByteReadChannel ? (ByteReadChannel)query : null;
        if (byteReadChannel == null) {
            return null;
        }
        ByteReadChannel channel = byteReadChannel;
        PipelineContext<Object, ApplicationCall> $this$call$iv = $this$defaultPlatformTransformations;
        boolean $i$f$getCall = false;
        KClass kClass = ApplicationCallKt.getReceiveType((ApplicationCall)((ApplicationCall)$this$call$iv.getContext())).getType();
        return Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(InputStream.class)) ? DefaultTransformJvmKt.receiveGuardedInputStream(channel) : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MultiPartData.class)) ? DefaultTransformJvmKt.multiPartData($this$defaultPlatformTransformations, channel) : null);
    }

    @NotNull
    public static final MultiPartData multiPartData(@NotNull PipelineContext<?, ApplicationCall> $this$multiPartData, @NotNull ByteReadChannel rc) {
        Intrinsics.checkNotNullParameter($this$multiPartData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rc, (String)"rc");
        PipelineContext<?, ApplicationCall> $this$call$iv = $this$multiPartData;
        boolean $i$f$getCall = false;
        String string = ApplicationRequestPropertiesKt.header((ApplicationRequest)((ApplicationCall)$this$call$iv.getContext()).getRequest(), (String)HttpHeaders.INSTANCE.getContentType());
        if (string == null) {
            throw new IllegalStateException("Content-Type header is required for multipart processing");
        }
        String contentType = string;
        PipelineContext<?, ApplicationCall> $this$call$iv2 = $this$multiPartData;
        boolean $i$f$getCall2 = false;
        String string2 = ApplicationRequestPropertiesKt.header((ApplicationRequest)((ApplicationCall)$this$call$iv2.getContext()).getRequest(), (String)HttpHeaders.INSTANCE.getContentLength());
        Long contentLength = string2 != null ? Long.valueOf(Long.parseLong(string2)) : null;
        return (MultiPartData)new CIOMultipartDataBase($this$multiPartData.getCoroutineContext().plus((CoroutineContext)Dispatchers.getUnconfined()), rc, (CharSequence)contentType, contentLength, 0, 0, 48, null);
    }

    @NotNull
    public static final String readTextWithCustomCharset(@NotNull ByteReadPacket $this$readTextWithCustomCharset, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readTextWithCustomCharset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return TextStreamsKt.readText((Reader)new InputStreamReader(StreamsKt.inputStream((ByteReadPacket)$this$readTextWithCustomCharset), charset));
    }

    private static final InputStream receiveGuardedInputStream(ByteReadChannel channel) {
        DefaultTransformJvmKt.checkSafeParking();
        return BlockingKt.toInputStream$default((ByteReadChannel)channel, null, (int)1, null);
    }

    private static final void checkSafeParking() {
        if (!BlockingBridgeKt.safeToRunInPlace()) {
            boolean bl = false;
            String string = "Acquiring blocking primitives on this dispatcher is not allowed. Consider using async channel or doing withContext(Dispatchers.IO) { call.receive<InputStream>().use { ... } } instead.";
            throw new IllegalStateException(string.toString());
        }
    }
}

