/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.sonatype.sisu.charger.CallableExecutor;
import org.sonatype.sisu.charger.ChargeFuture;
import org.sonatype.sisu.charger.ChargeStrategy;
import org.sonatype.sisu.charger.Charger;
import org.sonatype.sisu.charger.ExceptionHandler;
import org.sonatype.sisu.charger.internal.AllArrivedChargeStrategy;
import org.sonatype.sisu.charger.internal.DefaultCharger;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.internal.PayloadSupplier;
import org.sonatype.spice.zapper.internal.Protocol;
import org.sonatype.spice.zapper.internal.Transfer;
import org.sonatype.spice.zapper.internal.transport.AbstractChargerTrack;
import org.sonatype.spice.zapper.internal.transport.AbstractClient;
import org.sonatype.spice.zapper.internal.transport.SimpleCallableExecutor;
import org.sonatype.spice.zapper.internal.transport.State;
import org.sonatype.spice.zapper.internal.transport.TrackIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChargerClient<T extends AbstractChargerTrack>
extends AbstractClient<T> {
    private final Charger charger = new DefaultCharger();
    private final SimpleCallableExecutor executor;
    protected static ExceptionHandler NON_HANDLING_EXCEPTION_HANDLER = new ExceptionHandler(){

        public boolean handle(Exception ex) {
            return false;
        }
    };

    public AbstractChargerClient(Parameters parameters, String remoteUrl) {
        super(parameters, remoteUrl);
        this.executor = new SimpleCallableExecutor(parameters.getMaximumTrackCount());
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    @Override
    protected void doUpload(Transfer transfer, Protocol protocol, int trackCount) throws IOException {
        PayloadSupplier payloadSupplier = transfer.getPayloadSupplier();
        ArrayList<Callable<State>> tracks = new ArrayList<Callable<State>>(trackCount);
        for (int i = 0; i < trackCount; ++i) {
            tracks.add(this.createCallable(transfer.getNextTrackIdentifier(), transfer, protocol, payloadSupplier));
        }
        ChargeFuture chargeFuture = this.charger.submit(tracks, this.getExceptionHandler(), (ChargeStrategy)new AllArrivedChargeStrategy(), (CallableExecutor)this.executor);
        try {
            chargeFuture.getResult();
        }
        catch (IOException e) {
            if (e.getCause() == null) {
                IOException ee = new IOException("IO failure");
                ee.initCause(e);
                throw ee;
            }
            throw e;
        }
        catch (Exception e) {
            IOException ee = new IOException("IO failure");
            ee.initCause(e);
            throw ee;
        }
    }

    protected abstract Callable<State> createCallable(TrackIdentifier var1, Transfer var2, Protocol var3, PayloadSupplier var4);

    protected ExceptionHandler getExceptionHandler() {
        return NON_HANDLING_EXCEPTION_HANDLER;
    }
}

