/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.mojo.settings;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;

class Clone {
    Clone() {
    }

    public static <T> T copy(T orig) throws IllegalArgumentException {
        Object obj = Clone.tryClone(orig);
        if (obj != null) {
            return obj;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            obj = in.readObject();
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(String.format("Object of class %s is not copy-able!", orig.getClass().getName()), cnfe);
        }
        return obj;
    }

    public static <T> T tryClone(T orig) throws IllegalArgumentException {
        try {
            Method m = orig.getClass().getMethod("clone", new Class[0]);
            return (T)m.invoke(orig, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

