/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.ConvertibleColor;
import com.github.ajalt.colormath.ExtensionsKt;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.RGBKt;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tB\u001d\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0007\u001a\u00020\n\u0012\u0006\u0010\b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0010\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0011\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0012\u001a\u00020\nH\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\n2\b\b\u0002\u0010\b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0015H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0000H\u0016J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\b\u0010*\u001a\u00020+H\u0016R\u0011\u0010\b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006-"}, d2={"Lcom/github/ajalt/colormath/RGB;", "Lcom/github/ajalt/colormath/ConvertibleColor;", "hex", "", "(Ljava/lang/String;)V", "r", "", "g", "b", "(BBB)V", "", "(III)V", "getB", "()I", "getG", "getR", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toAnsi16", "Lcom/github/ajalt/colormath/Ansi16;", "value", "toAnsi256", "Lcom/github/ajalt/colormath/Ansi256;", "toCMYK", "Lcom/github/ajalt/colormath/CMYK;", "toHSL", "Lcom/github/ajalt/colormath/HSL;", "toHSV", "Lcom/github/ajalt/colormath/HSV;", "toHex", "withNumberSign", "toLAB", "Lcom/github/ajalt/colormath/LAB;", "toRGB", "toString", "toXYZ", "Lcom/github/ajalt/colormath/XYZ;", "Companion", "colorconversion"})
public final class RGB
implements ConvertibleColor {
    private final int r;
    private final int g;
    private final int b;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String toHex(boolean withNumberSign) {
        StringBuilder stringBuilder;
        int n = 7;
        StringBuilder $receiver = stringBuilder = new StringBuilder(n);
        if (withNumberSign) {
            $receiver.append('#');
        }
        $receiver.append(RGBKt.access$renderHex(this.r)).append(RGBKt.access$renderHex(this.g)).append(RGBKt.access$renderHex(this.b));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        double r = (double)this.r / 255.0;
        double g = (double)this.g / 255.0;
        double b = (double)this.b / 255.0;
        double d = Math.min(g, b);
        double min = Math.min(r, d);
        double d2 = Math.max(g, b);
        double max = Math.max(r, d2);
        double delta = max - min;
        double h = max == min ? 0.0 : (r == max ? (g - b) / delta : (g == max ? (double)2 + (b - r) / delta : (b == max ? (double)4 + (r - g) / delta : 0.0)));
        double d3 = h * (double)60;
        double d4 = 360.0;
        if ((h = Math.min(d3, d4)) < 0.0) {
            h += (double)360;
        }
        double l = (min + max) / 2.0;
        double s = max == min ? 0.0 : (l <= 0.5 ? delta / (max + min) : delta / ((double)2 - max - min));
        return new HSL(ExtensionsKt.roundToInt(h), ExtensionsKt.roundToInt(s * (double)100), ExtensionsKt.roundToInt(l * (double)100));
    }

    @Override
    @NotNull
    public HSV toHSV() {
        double s;
        double r = this.r;
        double g = this.g;
        double b = this.b;
        double d = Math.min(g, b);
        double min = Math.min(r, d);
        double d2 = Math.max(g, b);
        double max = Math.max(r, d2);
        double delta = max - min;
        double d3 = max;
        double d4 = s = d3 == 0.0 ? 0.0 : delta / max * (double)1000 / (double)10;
        double h = max == min ? 0.0 : (r == max ? (g - b) / delta : (g == max ? (double)2 + (b - r) / delta : (b == max ? (double)4 + (r - g) / delta : 0.0)));
        double d5 = h * (double)60;
        double d6 = 360.0;
        if ((h = Math.min(d5, d6)) < 0.0) {
            h += (double)360;
        }
        double v = max / (double)255 * (double)1000 / (double)10;
        return new HSV(ExtensionsKt.roundToInt(h), ExtensionsKt.roundToInt(s), ExtensionsKt.roundToInt(v));
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        toXYZ.1 adj$ = toXYZ.1.INSTANCE;
        double rL = adj$.invoke(this.r);
        double gL = adj$.invoke(this.g);
        double bL = adj$.invoke(this.b);
        double x = 0.4124564 * rL + 0.3575761 * gL + 0.1804375 * bL;
        double y = 0.2126729 * rL + 0.7151522 * gL + 0.072175 * bL;
        double z = 0.0193339 * rL + 0.119192 * gL + 0.9503041 * bL;
        return new XYZ(x * (double)100, y * (double)100, z * (double)100);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return this.toXYZ().toLAB();
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        double r = (double)this.r / 255.0;
        double b = (double)this.b / 255.0;
        double g = (double)this.g / 255.0;
        double d = 1.0;
        double d2 = Math.max(b, g);
        double d3 = Math.max(r, d2);
        double k = d - d3;
        double c = (1.0 - r - k) / (1.0 - k);
        double m = (1.0 - g - k) / (1.0 - k);
        double y = (1.0 - b - k) / (1.0 - k);
        return new CMYK(ExtensionsKt.percentToInt(c), ExtensionsKt.percentToInt(m), ExtensionsKt.percentToInt(y), ExtensionsKt.percentToInt(k));
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return this.toAnsi16(this.toHSV().getV());
    }

    private final Ansi16 toAnsi16(int value) {
        if (value == 30) {
            return new Ansi16(30);
        }
        int v = (int)Math.round((double)value / 50.0);
        int ansi = 30 + (ExtensionsKt.roundToInt((double)this.b / 255.0) * 4 | ExtensionsKt.roundToInt((double)this.g / 255.0) * 2 | ExtensionsKt.roundToInt((double)this.r / 255.0));
        return new Ansi16(v == 2 ? ansi + 60 : ansi);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        int code = this.r == this.g && this.g == this.b ? (this.r < 8 ? 16 : (this.r > 248 ? 231 : ExtensionsKt.roundToInt((double)(this.r - 8) / 247.0 * 24.0) + 232)) : 16 + 36 * ExtensionsKt.roundToInt((double)this.r / 255.0 * (double)5) + 6 * ExtensionsKt.roundToInt((double)this.g / 255.0 * (double)5) + ExtensionsKt.roundToInt((double)this.b / 255.0 * (double)5);
        return new Ansi256(code);
    }

    @Override
    @NotNull
    public RGB toRGB() {
        return this;
    }

    public final int getR() {
        return this.r;
    }

    public final int getG() {
        return this.g;
    }

    public final int getB() {
        return this.b;
    }

    public RGB(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
        int n = this.r;
        int n2 = n = 0 <= n && 255 >= n ? 1 : 0;
        if (n == 0) {
            String string = "r must be in range [0, 255] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.g;
        int n3 = n = 0 <= n && 255 >= n ? 1 : 0;
        if (n == 0) {
            String string = "g must be in range [0, 255] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.b;
        int n4 = n = 0 <= n && 255 >= n ? 1 : 0;
        if (n == 0) {
            String string = "b must be in range [0, 255] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public RGB(@NotNull String hex) {
        Intrinsics.checkParameterIsNotNull((Object)hex, (String)"hex");
        this(RGBKt.access$parseHex(RGBKt.access$validateHex(hex), 0), RGBKt.access$parseHex(hex, 2), RGBKt.access$parseHex(hex, 4));
    }

    public RGB(byte r, byte g, byte b) {
        this(r + 128, g + 128, b + 128);
    }

    public final int component1() {
        return this.r;
    }

    public final int component2() {
        return this.g;
    }

    public final int component3() {
        return this.b;
    }

    @NotNull
    public final RGB copy(int r, int g, int b) {
        return new RGB(r, g, b);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ RGB copy$default(RGB rGB, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = rGB.r;
        }
        if ((n4 & 2) != 0) {
            n2 = rGB.g;
        }
        if ((n4 & 4) != 0) {
            n3 = rGB.b;
        }
        return rGB.copy(n, n2, n3);
    }

    public String toString() {
        return "RGB(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ")";
    }

    public int hashCode() {
        return (this.r * 31 + this.g) * 31 + this.b;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RGB)) break block3;
                RGB rGB = (RGB)object;
                if (!(this.r == rGB.r) || !(this.g == rGB.g) || !(this.b == rGB.b)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/ajalt/colormath/RGB$Companion;", "", "()V", "fromInt", "Lcom/github/ajalt/colormath/RGB;", "argb", "", "colorconversion"})
    public static final class Companion {
        @NotNull
        public final RGB fromInt(int argb) {
            return new RGB(argb >>> 16 & 0xFF, argb >>> 8 & 0xFF, argb & 0xFF);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

