/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.runorder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.surefire.runorder.PrioritizedTest;
import org.apache.maven.plugin.surefire.runorder.Priority;
import org.apache.maven.plugin.surefire.runorder.RunEntryStatistics;
import org.apache.maven.plugin.surefire.runorder.ThreadedExecutionScheduler;
import org.apache.maven.surefire.report.ReportEntry;

public final class RunEntryStatisticsMap {
    private final Map<String, RunEntryStatistics> runEntryStatistics;
    private static final Pattern PARENS = Pattern.compile("^[^\\(\\)]+\\(([^\\\\(\\\\)]+)\\)$");

    public RunEntryStatisticsMap(Map<String, RunEntryStatistics> runEntryStatistics) {
        this.runEntryStatistics = new ConcurrentHashMap<String, RunEntryStatistics>(runEntryStatistics);
    }

    public RunEntryStatisticsMap() {
        this.runEntryStatistics = new ConcurrentHashMap<String, RunEntryStatistics>();
    }

    public static RunEntryStatisticsMap fromFile(File file) {
        if (file.exists()) {
            try {
                return RunEntryStatisticsMap.fromReader(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new RunEntryStatisticsMap();
    }

    static RunEntryStatisticsMap fromReader(Reader fileReader) throws IOException {
        HashMap<String, RunEntryStatistics> result = new HashMap<String, RunEntryStatistics>();
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line = bufferedReader.readLine();
        while (line != null) {
            if (!line.startsWith("#")) {
                RunEntryStatistics stats = RunEntryStatistics.fromString(line);
                result.put(stats.getTestName(), stats);
            }
            line = bufferedReader.readLine();
        }
        return new RunEntryStatisticsMap(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(File file) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter(fos);
        try {
            ArrayList<RunEntryStatistics> items = new ArrayList<RunEntryStatistics>(this.runEntryStatistics.values());
            Collections.sort(items, new RunCountComparator());
            for (RunEntryStatistics item : items) {
                printWriter.println(item.toString());
            }
            printWriter.flush();
        }
        finally {
            printWriter.close();
        }
    }

    public RunEntryStatistics findOrCreate(ReportEntry reportEntry) {
        RunEntryStatistics item = this.runEntryStatistics.get(reportEntry.getName());
        return item != null ? item : RunEntryStatistics.fromReportEntry(reportEntry);
    }

    public RunEntryStatistics createNextGeneration(ReportEntry reportEntry) {
        RunEntryStatistics newItem = this.findOrCreate(reportEntry);
        Integer elapsed = reportEntry.getElapsed();
        return newItem.nextGeneration(elapsed != null ? elapsed : 0);
    }

    public RunEntryStatistics createNextGenerationFailure(ReportEntry reportEntry) {
        RunEntryStatistics newItem = this.findOrCreate(reportEntry);
        Integer elapsed = reportEntry.getElapsed();
        return newItem.nextGenerationFailure(elapsed != null ? elapsed : 0);
    }

    public void add(RunEntryStatistics item) {
        this.runEntryStatistics.put(item.getTestName(), item);
    }

    public List<Class<?>> getPrioritizedTestsClassRunTime(List<Class<?>> testsToRun, int threadCount) {
        List<PrioritizedTest> prioritizedTests = this.getPrioritizedTests(testsToRun, new TestRuntimeComparator());
        ThreadedExecutionScheduler threadedExecutionScheduler = new ThreadedExecutionScheduler(threadCount);
        for (PrioritizedTest prioritizedTest1 : prioritizedTests) {
            threadedExecutionScheduler.addTest(prioritizedTest1);
        }
        return threadedExecutionScheduler.getResult();
    }

    public List<Class<?>> getPrioritizedTestsByFailureFirst(List<Class<?>> testsToRun) {
        List<PrioritizedTest> prioritizedTests = this.getPrioritizedTests(testsToRun, new LeastFailureComparator());
        return this.transformToClasses(prioritizedTests);
    }

    private List<PrioritizedTest> getPrioritizedTests(List<Class<?>> testsToRun, Comparator<Priority> priorityComparator) {
        Map classPriorities = this.getPriorities(priorityComparator);
        ArrayList<PrioritizedTest> tests = new ArrayList<PrioritizedTest>();
        for (Class<?> clazz : testsToRun) {
            Priority pri = (Priority)classPriorities.get(clazz.getName());
            if (pri == null) {
                pri = Priority.newTestClassPriority(clazz.getName());
            }
            PrioritizedTest prioritizedTest = new PrioritizedTest(clazz, pri);
            tests.add(prioritizedTest);
        }
        Collections.sort(tests, new PrioritizedTestComparator());
        return tests;
    }

    private List<Class<?>> transformToClasses(List<PrioritizedTest> tests) {
        ArrayList result = new ArrayList();
        for (PrioritizedTest test : tests) {
            result.add(test.getClazz());
        }
        return result;
    }

    private Map getPriorities(Comparator<Priority> priorityComparator) {
        HashMap<String, Priority> priorities = new HashMap<String, Priority>();
        for (String o : this.runEntryStatistics.keySet()) {
            String testNames = o;
            String clazzName = this.extractClassName(testNames);
            Priority priority = (Priority)priorities.get(clazzName);
            if (priority == null) {
                priority = new Priority(clazzName);
                priorities.put(clazzName, priority);
            }
            RunEntryStatistics itemStat = this.runEntryStatistics.get(testNames);
            priority.addItem(itemStat);
        }
        ArrayList items = new ArrayList(priorities.values());
        Collections.sort(items, priorityComparator);
        HashMap<String, Priority> result = new HashMap<String, Priority>();
        int i = 0;
        for (Priority pri : items) {
            pri.setPriority(i++);
            result.put(pri.getClassName(), pri);
        }
        return result;
    }

    String extractClassName(String displayName) {
        Matcher m = PARENS.matcher(displayName);
        return m.find() ? m.group(1) : displayName;
    }

    static final class LeastFailureComparator
    implements Comparator<Priority> {
        LeastFailureComparator() {
        }

        @Override
        public int compare(Priority o, Priority o1) {
            return o.getMinSuccessRate() - o1.getMinSuccessRate();
        }
    }

    static final class TestRuntimeComparator
    implements Comparator<Priority> {
        TestRuntimeComparator() {
        }

        @Override
        public int compare(Priority o, Priority o1) {
            return o1.getTotalRuntime() - o.getTotalRuntime();
        }
    }

    static final class PrioritizedTestComparator
    implements Comparator<PrioritizedTest> {
        PrioritizedTestComparator() {
        }

        @Override
        public int compare(PrioritizedTest o, PrioritizedTest o1) {
            return o.getPriority() - o1.getPriority();
        }
    }

    static final class RunCountComparator
    implements Comparator<RunEntryStatistics> {
        RunCountComparator() {
        }

        @Override
        public int compare(RunEntryStatistics o, RunEntryStatistics o1) {
            int runtime = o.getSuccessfulBuilds() - o1.getSuccessfulBuilds();
            return runtime == 0 ? o.getRunTime() - o1.getRunTime() : runtime;
        }
    }
}

