/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractInstallMojo
extends AbstractMojo {
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactInstaller installer;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="createChecksum", defaultValue="false")
    protected boolean createChecksum;
    @Parameter(property="updateReleaseInfo", defaultValue="false")
    protected boolean updateReleaseInfo;
    @Component(hint="md5")
    protected Digester md5Digester;
    @Component(hint="sha1")
    protected Digester sha1Digester;

    protected File getLocalRepoFile(Artifact artifact) {
        String path = this.localRepository.pathOf(artifact);
        return new File(this.localRepository.getBasedir(), path);
    }

    protected File getLocalRepoFile(ArtifactMetadata metadata) {
        String path = this.localRepository.pathOfLocalRepositoryMetadata(metadata, this.localRepository);
        return new File(this.localRepository.getBasedir(), path);
    }

    protected void installChecksums(Artifact artifact, Collection metadataFiles) throws MojoExecutionException {
        if (!this.createChecksum) {
            return;
        }
        File artifactFile = this.getLocalRepoFile(artifact);
        this.installChecksums(artifactFile);
        Collection metadatas = artifact.getMetadataList();
        if (metadatas != null) {
            for (ArtifactMetadata metadata : metadatas) {
                File metadataFile = this.getLocalRepoFile(metadata);
                metadataFiles.add(metadataFile);
            }
        }
    }

    protected void installChecksums(Collection metadataFiles) throws MojoExecutionException {
        for (File metadataFile : metadataFiles) {
            this.installChecksums(metadataFile);
        }
    }

    private void installChecksums(File installedFile) throws MojoExecutionException {
        boolean signatureFile = installedFile.getName().endsWith(".asc");
        if (installedFile.isFile() && !signatureFile) {
            this.installChecksum(installedFile, installedFile, this.md5Digester, ".md5");
            this.installChecksum(installedFile, installedFile, this.sha1Digester, ".sha1");
        }
    }

    private void installChecksum(File originalFile, File installedFile, Digester digester, String ext) throws MojoExecutionException {
        String checksum;
        this.getLog().debug((CharSequence)("Calculating " + digester.getAlgorithm() + " checksum for " + originalFile));
        try {
            checksum = digester.calc(originalFile);
        }
        catch (DigesterException e) {
            throw new MojoExecutionException("Failed to calculate " + digester.getAlgorithm() + " checksum for " + originalFile, (Exception)((Object)e));
        }
        File checksumFile = new File(installedFile.getAbsolutePath() + ext);
        this.getLog().debug((CharSequence)("Installing checksum to " + checksumFile));
        try {
            checksumFile.getParentFile().mkdirs();
            FileUtils.fileWrite((String)checksumFile.getAbsolutePath(), (String)"UTF-8", (String)checksum);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to install checksum to " + checksumFile, (Exception)e);
        }
    }
}

