/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.security;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import javax.annotation.Nullable;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.core.subsystem.security.Role;
import org.sonatype.nexus.client.core.subsystem.security.Roles;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.security.JerseyRole;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.security.rest.model.RoleListResourceResponse;
import org.sonatype.security.rest.model.RoleResource;
import org.sonatype.security.rest.model.RoleResourceResponse;

public class JerseyRoles
extends SubsystemSupport<JerseyNexusClient>
implements Roles {
    public JerseyRoles(JerseyNexusClient nexusClient) {
        super(nexusClient);
    }

    @Override
    public JerseyRole create(String id) {
        return new JerseyRole((JerseyNexusClient)this.getNexusClient(), id);
    }

    @Override
    public Role get(String id) {
        try {
            return this.convert(((RoleResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRoles.path(id)).get(RoleResourceResponse.class)).getData());
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public Collection<Role> get() {
        RoleListResourceResponse roles;
        try {
            roles = (RoleListResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("roles").get(RoleListResourceResponse.class);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        return Collections2.transform((Collection)roles.getData(), (Function)new Function<RoleResource, Role>(){

            public Role apply(@Nullable RoleResource input) {
                return JerseyRoles.this.convert(input);
            }
        });
    }

    private JerseyRole convert(@Nullable RoleResource resource) {
        if (resource == null) {
            return null;
        }
        JerseyRole role = new JerseyRole((JerseyNexusClient)this.getNexusClient(), resource.getId(), resource);
        role.overwriteWith(resource);
        return role;
    }

    static String path(String id) {
        try {
            return "roles/" + URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

