/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.security;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import javax.annotation.Nullable;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.core.subsystem.security.Privilege;
import org.sonatype.nexus.client.core.subsystem.security.Privileges;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.security.JerseyPrivilege;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.security.rest.model.PrivilegeListResourceResponse;
import org.sonatype.security.rest.model.PrivilegeStatusResource;
import org.sonatype.security.rest.model.PrivilegeStatusResourceResponse;

public class JerseyPrivileges
extends SubsystemSupport<JerseyNexusClient>
implements Privileges {
    public JerseyPrivileges(JerseyNexusClient nexusClient) {
        super(nexusClient);
    }

    @Override
    public JerseyPrivilege create(String id) {
        return new JerseyPrivilege((JerseyNexusClient)this.getNexusClient(), id);
    }

    @Override
    public Privilege create() {
        return this.create(null);
    }

    @Override
    public Privilege get(String id) {
        try {
            return this.convert(((PrivilegeStatusResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyPrivileges.path(id)).get(PrivilegeStatusResourceResponse.class)).getData());
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public Collection<Privilege> get() {
        PrivilegeListResourceResponse privileges;
        try {
            privileges = (PrivilegeListResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("privileges").get(PrivilegeListResourceResponse.class);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        return Collections2.transform((Collection)privileges.getData(), (Function)new Function<PrivilegeStatusResource, Privilege>(){

            public Privilege apply(@Nullable PrivilegeStatusResource input) {
                return JerseyPrivileges.this.convert(input);
            }
        });
    }

    private JerseyPrivilege convert(@Nullable PrivilegeStatusResource resource) {
        if (resource == null) {
            return null;
        }
        JerseyPrivilege privilege = new JerseyPrivilege((JerseyNexusClient)this.getNexusClient(), resource.getId(), resource);
        privilege.overwriteWith(resource);
        return privilege;
    }

    static String path(String id) {
        try {
            return "privileges/" + URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

