/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest;

import com.sun.jersey.core.provider.AbstractMessageReaderWriterProvider;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.sonatype.nexus.client.internal.util.Check;

@Provider
public class XStreamXmlProvider
extends AbstractMessageReaderWriterProvider<Object> {
    private static final String DEFAULT_ENCODING = "utf-8";
    private final MediaType xstreamMediaType;
    private final XStream xstream;

    public XStreamXmlProvider(XStream xstream, MediaType xstreamMediaType) {
        this.xstream = Check.notNull(xstream, XStream.class);
        this.xstream.allowTypesByWildcard(new String[]{"com.sonatype.nexus.rest.templates.settings.api.dto.*", "com.sonatype.nexus.procurement.api.dto.*DTO"});
        this.xstreamMediaType = Check.notNull(xstreamMediaType, MediaType.class);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.xstreamMediaType.isCompatible(mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.xstreamMediaType.isCompatible(mediaType);
    }

    protected String getCharsetAsString(MediaType m) {
        if (m == null) {
            return DEFAULT_ENCODING;
        }
        String result = (String)m.getParameters().get("charset");
        return result == null ? DEFAULT_ENCODING : result;
    }

    public Object readFrom(Class<Object> aClass, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> map, InputStream stream) throws IOException, WebApplicationException {
        String encoding = this.getCharsetAsString(mediaType);
        return this.xstream.fromXML((Reader)new InputStreamReader(stream, encoding));
    }

    public void writeTo(Object o, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> map, OutputStream stream) throws IOException, WebApplicationException {
        String encoding = this.getCharsetAsString(mediaType);
        this.xstream.marshal(o, (HierarchicalStreamWriter)new CompactWriter((Writer)new OutputStreamWriter(stream, encoding)));
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            String encoding = this.getCharsetAsString(mediaType);
            this.xstream.marshal(o, (HierarchicalStreamWriter)new CompactWriter((Writer)new OutputStreamWriter((OutputStream)bos, encoding)));
            return bos.size();
        }
        catch (UnsupportedEncodingException e) {
            return -1L;
        }
    }
}

