/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.spice.zapper.Client;
import org.sonatype.spice.zapper.IOSource;
import org.sonatype.spice.zapper.IOSourceListable;
import org.sonatype.spice.zapper.IOTarget;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.ZFile;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.Payload;
import org.sonatype.spice.zapper.internal.Protocol;
import org.sonatype.spice.zapper.internal.ProtocolIdentifier;
import org.sonatype.spice.zapper.internal.Transfer;
import org.sonatype.spice.zapper.internal.TransferIdentifier;
import org.sonatype.spice.zapper.internal.transport.State;
import org.sonatype.spice.zapper.internal.transport.Track;
import org.sonatype.spice.zapper.internal.wholefile.WholeZFileProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClient<T extends Track>
implements Client {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Parameters parameters;
    private final String remoteUrl;
    private final Protocol protocol;

    public AbstractClient(Parameters parameters, String remoteUrl) {
        this.parameters = Check.notNull(parameters, Parameters.class);
        this.remoteUrl = Check.notNull(remoteUrl, "Remote URL is null!");
        this.protocol = this.handshake();
    }

    @Override
    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    @Override
    public void upload(IOSourceListable listableSource) throws IOException {
        this.upload((IOSource)listableSource, listableSource.listFiles());
    }

    @Override
    public void upload(IOSource source, Path ... paths) throws IOException {
        ArrayList<ZFile> zfiles = new ArrayList<ZFile>();
        for (Path path : paths) {
            zfiles.add(source.createZFile(path));
        }
        this.upload(source, zfiles);
    }

    @Override
    public void download(IOTarget target, Path ... paths) throws IOException {
        throw new UnsupportedOperationException("Not implemented!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upload(IOSource source, List<ZFile> _zfiles) throws IOException {
        Transfer transfer = new Transfer(UUID.randomUUID().toString(), _zfiles);
        this.getLogger().info("Starting upload transfer ID \"{}\" (using protocol \"{}\")", (Object)((TransferIdentifier)transfer.getIdentifier()).stringValue(), (Object)((ProtocolIdentifier)this.protocol.getIdentifier()).stringValue());
        int segmentCount = this.protocol.getSegmentCreator().createSegments(transfer);
        int trackCount = Math.min(this.getParameters().getMaximumTrackCount(), segmentCount);
        int payloadCount = this.protocol.getPayloadCreator().createPayloads(transfer, source, this.getRemoteUrl());
        this.getLogger().info("Uploading total of {} bytes (in {} files) as {} segments ({} payloads) over {} tracks.", new Object[]{transfer.getTotalSize(), transfer.getZfiles().size(), segmentCount, payloadCount, trackCount});
        long started = System.currentTimeMillis();
        boolean success = false;
        try {
            this.protocol.beforeUpload(transfer, this);
            this.doUpload(transfer, this.protocol, trackCount);
            this.protocol.afterUpload(transfer, this);
            success = true;
        }
        finally {
            source.close(success);
        }
        this.getLogger().info("Upload finished in {} seconds.", (Object)((System.currentTimeMillis() - started) / 1000L));
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected Parameters getParameters() {
        return this.parameters;
    }

    protected Protocol handshake() {
        return new WholeZFileProtocol(this.getParameters());
    }

    public abstract State upload(Payload var1) throws IOException;

    public abstract State upload(Payload var1, T var2) throws IOException;

    protected abstract void doUpload(Transfer var1, Protocol var2, int var3) throws IOException;
}

