/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.util.Collection;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionConverter
extends AbstractConfigurationConverter {
    protected abstract Collection<Object> instantiateCollection(PlexusConfiguration var1, Class<?> var2, ClassLoader var3) throws ComponentConfigurationException;

    protected final Collection<Object> fromChildren(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener, Class<?> elementType) throws ComponentConfigurationException {
        Collection<Object> elements = this.instantiateCollection(configuration, type, loader);
        int size = configuration.getChildCount();
        for (int i = 0; i < size; ++i) {
            PlexusConfiguration xml = configuration.getChild(i);
            Class<?> childType = this.getChildType(xml, enclosingType, loader, elementType);
            ConfigurationConverter converter = lookup.lookupConverterForType(childType);
            elements.add(converter.fromConfiguration(lookup, xml, childType, enclosingType, loader, evaluator, listener));
        }
        return elements;
    }

    protected final Class<?> getChildType(PlexusConfiguration childConfiguration, Class<?> enclosingType, ClassLoader loader, Class<?> elementType) throws ComponentConfigurationException {
        String childName = this.fromXML(childConfiguration.getName());
        Class<Object> childType = this.getClassForImplementationHint(null, childConfiguration, loader);
        Throwable cause = null;
        if (null == childType && childName.indexOf(46) > 0) {
            try {
                childType = loader.loadClass(childName);
            }
            catch (Exception e) {
                cause = e;
            }
            catch (LinkageError e) {
                cause = e;
            }
        }
        if (null == childType) {
            try {
                childType = loader.loadClass(AbstractCollectionConverter.alignPackageName(enclosingType.getName(), childName));
            }
            catch (Exception e) {
                cause = e;
            }
            catch (LinkageError e) {
                cause = e;
            }
        }
        if (null == childType) {
            if (null != elementType && Object.class != elementType) {
                childType = elementType;
            } else if (childConfiguration.getChildCount() == 0) {
                childType = String.class;
            } else {
                throw new ComponentConfigurationException("Cannot determine child type", cause);
            }
        }
        return childType;
    }

    protected static final PlexusConfiguration csvToXml(PlexusConfiguration configuration, String csv) {
        XmlPlexusConfiguration xml = new XmlPlexusConfiguration(configuration.getName());
        if (csv.length() > 0) {
            for (String token : csv.split(",", -1)) {
                xml.addChild("#", token);
            }
        }
        return xml;
    }

    private static String alignPackageName(String enclosingName, String childName) {
        String pkgPrefix = enclosingName.substring(0, enclosingName.lastIndexOf(46) + 1);
        String clzSuffix = Character.toTitleCase(childName.charAt(0)) + childName.substring(1);
        return pkgPrefix + clzSuffix;
    }
}

