/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.maven.surefire.api.util.internal.StringUtils;
import org.apache.maven.surefire.shared.io.output.DeferredFileOutputStream;

class Utf8RecodingDeferredFileOutputStream {
    private DeferredFileOutputStream deferredFileOutputStream;
    private boolean closed = false;

    Utf8RecodingDeferredFileOutputStream(String channel) {
        this.deferredFileOutputStream = new DeferredFileOutputStream(1000000, channel, "deferred", null);
    }

    public synchronized void write(String output, boolean newLine) throws IOException {
        if (this.closed) {
            return;
        }
        if (output == null) {
            output = "null";
        }
        this.deferredFileOutputStream.write(output.getBytes(StandardCharsets.UTF_8));
        if (newLine) {
            this.deferredFileOutputStream.write(StringUtils.NL.getBytes(StandardCharsets.UTF_8));
        }
    }

    public long getByteCount() {
        return this.deferredFileOutputStream.getByteCount();
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.deferredFileOutputStream.close();
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        if (this.closed) {
            this.deferredFileOutputStream.writeTo(out);
        }
    }

    public synchronized void free() {
        if (null != this.deferredFileOutputStream && null != this.deferredFileOutputStream.getFile()) {
            try {
                this.closed = true;
                this.deferredFileOutputStream.close();
                if (!this.deferredFileOutputStream.getFile().delete()) {
                    this.deferredFileOutputStream.getFile().deleteOnExit();
                }
            }
            catch (IOException ioe) {
                this.deferredFileOutputStream.getFile().deleteOnExit();
            }
        }
    }
}

