/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.locators;

import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonatype.guice.bean.locators.QualifiedBean;
import org.sonatype.guice.plexus.config.PlexusBean;
import org.sonatype.guice.plexus.locators.LazyPlexusBean;
import org.sonatype.guice.plexus.locators.MissingPlexusBean;
import org.sonatype.guice.plexus.locators.PlexusBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GlobalPlexusBeans<T>
implements PlexusBeans<T> {
    private final List<PlexusBean<T>> defaultPlexusBeans;
    private volatile Iterable<PlexusBean<T>> cachedPlexusBeans;
    Iterable<QualifiedBean<Named, T>> beans;

    GlobalPlexusBeans(TypeLiteral<T> role, String ... hints) {
        if (hints.length > 0) {
            this.defaultPlexusBeans = new ArrayList<PlexusBean<T>>(hints.length);
            for (String hint : hints) {
                this.defaultPlexusBeans.add(new MissingPlexusBean<T>(role, hint));
            }
        } else {
            this.defaultPlexusBeans = Collections.emptyList();
        }
    }

    @Override
    public final void setBeans(Iterable<QualifiedBean<Named, T>> beans) {
        this.beans = beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<PlexusBean<T>> iterator() {
        Iterable<QualifiedBean<Named, T>> iterable = this.beans;
        synchronized (iterable) {
            Iterable<PlexusBean<PlexusBean<T>>> plexusBeans = this.cachedPlexusBeans;
            if (this.refreshCache() || null == plexusBeans) {
                plexusBeans = GlobalPlexusBeans.getPlexusBeans(this.getVisibleBeans(), this.defaultPlexusBeans);
                this.cachedPlexusBeans = plexusBeans;
            }
            return plexusBeans.iterator();
        }
    }

    @Override
    public final void run() {
        this.cachedPlexusBeans = null;
    }

    protected boolean refreshCache() {
        return false;
    }

    protected Iterable<QualifiedBean<Named, T>> getVisibleBeans() {
        return this.beans;
    }

    static final <T> Iterable<PlexusBean<T>> getPlexusBeans(Iterable<QualifiedBean<Named, T>> beans, List<PlexusBean<T>> defaultPlexusBeans) {
        Iterator<QualifiedBean<Named, T>> i = beans.iterator();
        if (!i.hasNext()) {
            return defaultPlexusBeans;
        }
        int expectedSize = defaultPlexusBeans.size();
        if (expectedSize == 0) {
            ArrayList<PlexusBean<T>> plexusBeans = new ArrayList<PlexusBean<T>>();
            while (i.hasNext()) {
                plexusBeans.add(new LazyPlexusBean<T>(i.next()));
            }
            return plexusBeans;
        }
        int beanCount = 0;
        ArrayList<PlexusBean<T>> plexusBeans = new ArrayList<PlexusBean<T>>(defaultPlexusBeans);
        while (i.hasNext()) {
            QualifiedBean<Named, T> bean = i.next();
            String key = ((Named)bean.getKey()).value();
            for (int n = 0; n < expectedSize; ++n) {
                PlexusBean b = (PlexusBean)plexusBeans.get(n);
                if (!key.equals(b.getKey()) || !(b instanceof MissingPlexusBean)) continue;
                plexusBeans.set(n, new LazyPlexusBean<T>(bean));
                if (++beanCount != expectedSize) continue;
                return plexusBeans;
            }
        }
        return plexusBeans;
    }
}

