/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.manager;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.natives.linker.Ranlib;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.manager.RanlibManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

@Component(role=RanlibManager.class, hint="native-ranlib-provider-manager")
public class DefaultRanlibManager
extends AbstractLogEnabled
implements RanlibManager,
Initializable {
    @Requirement(role=Ranlib.class)
    private Map<String, Ranlib> providers;

    public void initialize() {
        if (this.providers == null) {
            this.providers = new HashMap<String, Ranlib>();
        }
        if (this.providers.size() == 0) {
            this.getLogger().warn("No ranlib providers configured.");
        }
    }

    @Override
    public Ranlib getRanlib(String providerType) throws NoSuchNativeProviderException {
        Ranlib provider = this.providers.get(providerType);
        if (provider == null) {
            throw new NoSuchNativeProviderException(providerType);
        }
        return provider;
    }
}

