/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.util.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import org.apache.maven.surefire.api.util.internal.WritableBufferedByteChannel;

abstract class AbstractNoninterruptibleWritableChannel
implements WritableBufferedByteChannel {
    private volatile boolean open = true;

    AbstractNoninterruptibleWritableChannel() {
    }

    protected abstract void writeImpl(ByteBuffer var1) throws IOException;

    protected abstract void closeImpl() throws IOException;

    protected abstract void flushImpl() throws IOException;

    @Override
    public final int write(ByteBuffer src) throws IOException {
        return this.write(src, true);
    }

    @Override
    public final void writeBuffered(ByteBuffer src) throws IOException {
        this.write(src, false);
    }

    int write(ByteBuffer src, boolean flush) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!src.hasArray() || src.isReadOnly()) {
            throw new NonWritableChannelException();
        }
        if (src.remaining() != src.capacity()) {
            src.flip();
        }
        int countWrittenBytes = 0;
        if (src.hasRemaining()) {
            countWrittenBytes = src.remaining();
            this.writeImpl(src);
            src.position(src.limit());
            if (flush) {
                this.flushImpl();
            }
        }
        return countWrittenBytes;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final void close() throws IOException {
        this.open = false;
        this.closeImpl();
    }
}

