/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shared.utils.logging;

import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;

class PlainMessageBuilder
implements MessageBuilder {
    private StringBuilder buffer;

    PlainMessageBuilder() {
        this.buffer = new StringBuilder();
    }

    PlainMessageBuilder(StringBuilder builder) {
        this.buffer = builder;
    }

    PlainMessageBuilder(int size) {
        this.buffer = new StringBuilder(size);
    }

    @Override
    public PlainMessageBuilder debug(Object message) {
        return this.a(message);
    }

    @Override
    public PlainMessageBuilder info(Object message) {
        return this.a(message);
    }

    @Override
    public PlainMessageBuilder warning(Object message) {
        return this.a(message);
    }

    @Override
    public PlainMessageBuilder error(Object message) {
        return this.a(message);
    }

    @Override
    public PlainMessageBuilder success(Object message) {
        return this.a(message);
    }

    @Override
    public PlainMessageBuilder failure(Object message) {
        return this.a(message);
    }

    @Override
    public PlainMessageBuilder strong(Object message) {
        return this.a(message);
    }

    @Override
    public PlainMessageBuilder mojo(Object message) {
        return this.a(message);
    }

    @Override
    public PlainMessageBuilder project(Object message) {
        return this.a(message);
    }

    @Override
    public PlainMessageBuilder a(char[] value, int offset, int len) {
        this.buffer.append(value, offset, len);
        return this;
    }

    @Override
    public PlainMessageBuilder a(char[] value) {
        this.buffer.append(value);
        return this;
    }

    @Override
    public PlainMessageBuilder a(CharSequence value, int start, int end) {
        this.buffer.append(value, start, end);
        return this;
    }

    @Override
    public PlainMessageBuilder a(CharSequence value) {
        this.buffer.append(value);
        return this;
    }

    @Override
    public PlainMessageBuilder a(Object value) {
        this.buffer.append(value);
        return this;
    }

    @Override
    public PlainMessageBuilder newline() {
        this.buffer.append(System.getProperty("line.separator"));
        return this;
    }

    @Override
    public PlainMessageBuilder format(String pattern, Object ... args) {
        this.buffer.append(String.format(pattern, args));
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

