/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.maven.shared.dependency.tree.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTreePreorderIterator
implements Iterator<DependencyNode> {
    private Stack<DependencyNode> nodesToProcess = new Stack();

    public DependencyTreePreorderIterator(DependencyNode rootNode) {
        this.nodesToProcess.push(rootNode);
    }

    @Override
    public boolean hasNext() {
        return !this.nodesToProcess.isEmpty();
    }

    @Override
    public DependencyNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DependencyNode currentNode = this.nodesToProcess.pop();
        List<DependencyNode> children = currentNode.getChildren();
        if (children != null) {
            for (int i = children.size() - 1; i >= 0; --i) {
                this.nodesToProcess.push(children.get(i));
            }
        }
        return currentNode;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

