/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenProjectValueSource;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.PropertiesEscapingBackSlashValueSource;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DefaultMavenFileFilter
extends AbstractLogEnabled
implements MavenFileFilter {
    public void copyFile(File from, File to, boolean filtering, MavenProject mavenProject, List filters, boolean escapedBackslashesInFilePath, String encoding, MavenSession mavenSession) throws MavenFilteringException {
        List filterWrappers = this.getDefaultFilterWrappers(mavenProject, filters, escapedBackslashesInFilePath, mavenSession);
        this.copyFile(from, to, filtering, filterWrappers, encoding);
    }

    public void copyFile(File from, File to, boolean filtering, List filterWrappers, String encoding) throws MavenFilteringException {
        this.copyFile(from, to, filtering, filterWrappers, encoding, false);
    }

    public void copyFile(File from, File to, boolean filtering, List filterWrappers, String encoding, boolean overwrite) throws MavenFilteringException {
        try {
            if (filtering) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("filering " + from.getPath() + " to " + to.getPath());
                }
                FileUtils.FilterWrapper[] wrappers = filterWrappers.toArray(new FileUtils.FilterWrapper[filterWrappers.size()]);
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])wrappers);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("copy " + from.getPath() + " to " + to.getPath());
                }
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])new FileUtils.FilterWrapper[0], (boolean)overwrite);
            }
        }
        catch (IOException e) {
            throw new MavenFilteringException(e.getMessage(), e);
        }
    }

    public List getDefaultFilterWrappers(MavenProject mavenProject, List filters, boolean escapedBackslashesInFilePath, MavenSession mavenSession) throws MavenFilteringException {
        return this.getDefaultFilterWrappers(mavenProject, filters, escapedBackslashesInFilePath, mavenSession, null);
    }

    public List getDefaultFilterWrappers(final MavenProject mavenProject, List filters, final boolean escapedBackslashesInFilePath, MavenSession mavenSession, MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        Properties baseProps = new Properties();
        baseProps.putAll((Map<?, ?>)(mavenProject.getProperties() == null ? Collections.EMPTY_MAP : mavenProject.getProperties()));
        if (mavenSession != null) {
            baseProps.putAll((Map<?, ?>)mavenSession.getExecutionProperties());
        }
        Properties filterProperties = new Properties();
        this.loadProperties(filterProperties, filters, baseProps);
        this.loadProperties(filterProperties, mavenProject.getBuild().getFilters(), baseProps);
        filterProperties.putAll((Map<?, ?>)(mavenProject.getProperties() == null ? Collections.EMPTY_MAP : mavenProject.getProperties()));
        if (mavenSession != null) {
            filterProperties.putAll((Map<?, ?>)mavenSession.getExecutionProperties());
        }
        ArrayList<FileUtils.FilterWrapper> defaultFilterWrappers = new ArrayList<FileUtils.FilterWrapper>(3);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("properties used " + filterProperties);
        }
        final PropertiesEscapingBackSlashValueSource propertiesValueSource = new PropertiesEscapingBackSlashValueSource(escapedBackslashesInFilePath, filterProperties);
        final String escapeString = mavenResourcesExecution == null ? null : mavenResourcesExecution.getEscapeString();
        FileUtils.FilterWrapper one = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                StringSearchInterpolator propertiesInterpolator = new StringSearchInterpolator();
                propertiesInterpolator.addValueSource(propertiesValueSource);
                propertiesInterpolator.setEscapeString(escapeString);
                InterpolatorFilterReader filterReader = new InterpolatorFilterReader(reader, (Interpolator)propertiesInterpolator);
                filterReader.setInterpolateWithPrefixPattern(false);
                filterReader.setEscapeString(escapeString);
                filterReader.setPreserveEscapeString(true);
                return filterReader;
            }
        };
        defaultFilterWrappers.add(one);
        FileUtils.FilterWrapper second = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                StringSearchInterpolator propertiesInterpolator = new StringSearchInterpolator("@", "@");
                propertiesInterpolator.addValueSource(propertiesValueSource);
                propertiesInterpolator.setEscapeString(escapeString);
                InterpolatorFilterReader filterReader = new InterpolatorFilterReader(reader, (Interpolator)propertiesInterpolator, "@", "@");
                filterReader.setInterpolateWithPrefixPattern(false);
                filterReader.setEscapeString(escapeString);
                filterReader.setPreserveEscapeString(true);
                return filterReader;
            }
        };
        defaultFilterWrappers.add(second);
        FileUtils.FilterWrapper third = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                StringSearchInterpolator mavenProjectInterpolator = new StringSearchInterpolator();
                MavenProjectValueSource valueSource = new MavenProjectValueSource(mavenProject, escapedBackslashesInFilePath);
                mavenProjectInterpolator.addValueSource((ValueSource)valueSource);
                mavenProjectInterpolator.setEscapeString(escapeString);
                InterpolatorFilterReader filterReader = new InterpolatorFilterReader(reader, (Interpolator)mavenProjectInterpolator);
                filterReader.setInterpolateWithPrefixPattern(false);
                filterReader.setEscapeString(escapeString);
                return filterReader;
            }
        };
        defaultFilterWrappers.add(third);
        FileUtils.FilterWrapper fourth = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                StringSearchInterpolator mavenProjectInterpolator = new StringSearchInterpolator("@", "@");
                MavenProjectValueSource valueSource = new MavenProjectValueSource(mavenProject, escapedBackslashesInFilePath);
                mavenProjectInterpolator.addValueSource((ValueSource)valueSource);
                mavenProjectInterpolator.setEscapeString(escapeString);
                InterpolatorFilterReader filterReader = new InterpolatorFilterReader(reader, (Interpolator)mavenProjectInterpolator, "@", "@");
                filterReader.setInterpolateWithPrefixPattern(false);
                filterReader.setEscapeString(escapeString);
                return filterReader;
            }
        };
        defaultFilterWrappers.add(fourth);
        return defaultFilterWrappers;
    }

    private void loadProperties(Properties filterProperties, List propertiesFilePaths, Properties baseProps) throws MavenFilteringException {
        if (propertiesFilePaths != null) {
            Iterator iterator = propertiesFilePaths.iterator();
            while (iterator.hasNext()) {
                String filterFile = (String)iterator.next();
                if (StringUtils.isEmpty((String)filterFile)) continue;
                try {
                    Properties properties = PropertyUtils.loadPropertyFile(new File(filterFile), baseProps);
                    filterProperties.putAll((Map<?, ?>)properties);
                }
                catch (IOException e) {
                    throw new MavenFilteringException("Error loading property file '" + filterFile + "'", e);
                }
            }
        }
    }
}

