/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewriteRegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.resource.Resource;
import org.jitsi.rest.AbstractJettyBundleActivator;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.ConfigUtils;
import org.jitsi.videobridge.rest.ColibriWebSocketService;
import org.jitsi.videobridge.rest.HandlerImpl;
import org.jitsi.videobridge.rest.LongPollingServlet;
import org.jitsi.videobridge.rest.ProxyServletImpl;
import org.jitsi.videobridge.rest.TraceFilter;
import org.jitsi.videobridge.rest.ssi.SSIResourceHandler;
import org.osgi.framework.BundleContext;

public class PublicRESTBundleActivator
extends AbstractJettyBundleActivator {
    public static final String JETTY_PROPERTY_PREFIX = "org.jitsi.videobridge.rest";
    public static final String JETTY_PROXY_SERVLET_HOST_HEADER_PNAME = ".jetty.ProxyServlet.hostHeader";
    public static final String JETTY_PROXY_SERVLET_PATH_SPEC_PNAME = ".jetty.ProxyServlet.pathSpec";
    public static final String JETTY_PROXY_SERVLET_PROXY_TO_PNAME = ".jetty.ProxyServlet.proxyTo";
    public static final String JETTY_RESOURCE_HANDLER_RESOURCE_BASE_PNAME = ".jetty.ResourceHandler.resourceBase";
    public static final String JETTY_CORS_ALLOWED_ORIGINS = ".jetty.cors.allowedOrigins";
    public static final String JETTY_RESOURCE_HANDLER_ALIAS_PREFIX = ".jetty.ResourceHandler.alias";
    public static final String JETTY_REWRITE_HANDLER_REGEX_PNAME = ".jetty.RewriteHandler.regex";
    public static final String JETTY_REWRITE_HANDLER_REPLACEMENT_PNAME = ".jetty.RewriteHandler.replacement";
    private ColibriWebSocketService colibriWebSocketService;

    public PublicRESTBundleActivator() {
        super(JETTY_PROPERTY_PREFIX);
    }

    protected void doStop(BundleContext bundleContext) throws Exception {
        if (this.server != null) {
            Thread.sleep(1000L);
        }
        super.doStop(bundleContext);
    }

    protected Handler initializeHandler(BundleContext bundleContext, Server server) throws Exception {
        Handler handler = super.initializeHandler(bundleContext, server);
        HandlerWrapper rewriteHandler = this.initializeRewriteHandler(bundleContext, server);
        if (rewriteHandler != null) {
            rewriteHandler.setHandler(handler);
            handler = rewriteHandler;
        }
        return handler;
    }

    protected Handler initializeHandlerList(BundleContext bundleContext, Server server) throws Exception {
        Handler servletHandler;
        Handler redirectHandler;
        Handler aliasHandler;
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        Handler resourceHandler = this.initializeResourceHandler(bundleContext, server);
        if (resourceHandler != null) {
            handlers.add(resourceHandler);
        }
        if ((aliasHandler = this.initializeResourceHandlerAliases(bundleContext, server)) != null) {
            handlers.add(aliasHandler);
        }
        if ((redirectHandler = this.initializeRedirectHandler(bundleContext, server)) != null) {
            handlers.add(redirectHandler);
        }
        if ((servletHandler = this.initializeServletHandler(bundleContext, server)) != null) {
            handlers.add(servletHandler);
        }
        return PublicRESTBundleActivator.initializeHandlerList(handlers);
    }

    private ServletHolder initializeLongPollingServlet(ServletContextHandler servletContextHandler) {
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)new LongPollingServlet());
        servletContextHandler.addServlet(holder, HandlerImpl.COLIBRI_TARGET + "*");
        return holder;
    }

    private ServletHolder initializeProxyServlet(ServletContextHandler servletContextHandler) {
        String proxyTo;
        String pathSpec = ConfigUtils.getString((ConfigurationService)this.cfg, (String)"org.jitsi.videobridge.rest.jetty.ProxyServlet.pathSpec", null);
        ServletHolder holder = null;
        if (pathSpec != null && pathSpec.length() != 0 && (proxyTo = ConfigUtils.getString((ConfigurationService)this.cfg, (String)"org.jitsi.videobridge.rest.jetty.ProxyServlet.proxyTo", null)) != null && proxyTo.length() != 0) {
            holder = new ServletHolder();
            holder.setHeldClass(ProxyServletImpl.class);
            holder.setInitParameter("maxThreads", Integer.toString(256));
            holder.setInitParameter("prefix", pathSpec);
            holder.setInitParameter("proxyTo", proxyTo);
            String hostHeader = ConfigUtils.getString((ConfigurationService)this.cfg, (String)"org.jitsi.videobridge.rest.jetty.ProxyServlet.hostHeader", null);
            if (hostHeader != null && hostHeader.length() != 0) {
                holder.setInitParameter("hostHeader", hostHeader);
            }
            servletContextHandler.addServlet(holder, pathSpec);
            String allowedOrigins = ConfigUtils.getString((ConfigurationService)this.cfg, (String)"org.jitsi.videobridge.rest.jetty.cors.allowedOrigins", null);
            if (allowedOrigins != null && allowedOrigins.length() != 0) {
                FilterHolder filterHolder = servletContextHandler.addFilter(CrossOriginFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
                filterHolder.setInitParameter("allowedOrigins", allowedOrigins);
            }
            servletContextHandler.addFilter(TraceFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        return holder;
    }

    private Handler initializeResourceHandler(BundleContext bundleContext, Server server) {
        ContextHandler contextHandler;
        String resourceBase = ConfigUtils.getString((ConfigurationService)this.cfg, (String)"org.jitsi.videobridge.rest.jetty.ResourceHandler.resourceBase", null);
        if (resourceBase == null || resourceBase.length() == 0) {
            contextHandler = null;
        } else {
            SSIResourceHandler resourceHandler = new SSIResourceHandler(this.cfg);
            resourceHandler.setResourceBase(resourceBase);
            contextHandler = new ContextHandler();
            contextHandler.setHandler((Handler)resourceHandler);
            contextHandler.addAliasCheck((ContextHandler.AliasCheck)new ContextHandler.ApproveAliases());
        }
        return contextHandler;
    }

    private Handler initializeResourceHandlerAliases(BundleContext bundleContext, Server server) {
        return new ResourceHandler(){

            public Resource getResource(String path) throws MalformedURLException {
                String property = ".jetty.ResourceHandler.alias." + path;
                String value = ConfigUtils.getString((ConfigurationService)PublicRESTBundleActivator.this.cfg, (String)(PublicRESTBundleActivator.JETTY_PROPERTY_PREFIX + property), null);
                return value == null ? null : Resource.newResource((String)value);
            }
        };
    }

    private Handler initializeRedirectHandler(BundleContext bundleContext, Server server) {
        String privateSslContextFactoryKeyStorePath = this.getCfgString("org.jitsi.videobridge.rest.private.jetty.sslContextFactory.keyStorePath", null);
        int privatePort = privateSslContextFactoryKeyStorePath == null ? this.cfg.getInt("org.jitsi.videobridge.rest.private.jetty.port", 8080) : this.cfg.getInt("org.jitsi.videobridge.rest.private.jetty.tls.port", 8443);
        if (privatePort > 0) {
            return new RedirectHandler(privateSslContextFactoryKeyStorePath == null ? "http" : "https", privatePort);
        }
        return null;
    }

    private HandlerWrapper initializeRewriteHandler(BundleContext bundleContext, Server server) {
        String replacement;
        String regex = ConfigUtils.getString((ConfigurationService)this.cfg, (String)"org.jitsi.videobridge.rest.jetty.RewriteHandler.regex", null);
        RewriteHandler handler = null;
        if (regex != null && regex.length() != 0 && (replacement = ConfigUtils.getString((ConfigurationService)this.cfg, (String)"org.jitsi.videobridge.rest.jetty.RewriteHandler.replacement", null)) != null) {
            RewriteRegexRule rule = new RewriteRegexRule();
            rule.setRegex(regex);
            rule.setReplacement(replacement);
            handler = new RewriteHandler();
            handler.addRule((Rule)rule);
        }
        return handler;
    }

    private Handler initializeServletHandler(BundleContext bundleContext, Server server) {
        ColibriWebSocketService colibriWebSocketService;
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        boolean b = false;
        ServletHolder servletHolder = this.initializeProxyServlet(servletContextHandler);
        if (servletHolder != null) {
            b = true;
        }
        if ((servletHolder = this.initializeLongPollingServlet(servletContextHandler)) != null) {
            b = true;
        }
        if ((servletHolder = (colibriWebSocketService = new ColibriWebSocketService(bundleContext, this.isTls())).initializeColibriWebSocketServlet(bundleContext, servletContextHandler)) != null) {
            this.colibriWebSocketService = colibriWebSocketService;
            b = true;
        }
        if (b) {
            servletContextHandler.setContextPath("/");
        } else {
            servletContextHandler = null;
        }
        return servletContextHandler;
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected int getDefaultTlsPort() {
        return -1;
    }

    protected void didStart(BundleContext bundleContext) throws Exception {
        super.didStart(bundleContext);
        if (this.colibriWebSocketService != null) {
            bundleContext.registerService(ColibriWebSocketService.class.getName(), (Object)this.colibriWebSocketService, null);
        }
    }

    private class RedirectHandler
    extends AbstractHandler {
        private final String targetProtocol;
        private final int targetPort;

        RedirectHandler(String targetProtocol, int targetPort) {
            this.targetProtocol = targetProtocol;
            this.targetPort = targetPort;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (target.startsWith("/colibri/") || target.startsWith("/about/")) {
                String host = request.getServerName();
                String location = this.targetProtocol + "://" + host + ":" + this.targetPort + target;
                response.setHeader("Location", location);
                response.setStatus(301);
                response.setContentLength(0);
                baseRequest.setHandled(true);
            }
        }
    }
}

