/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidateType;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RawUdpTransportPacketExtension;
import org.osgi.framework.BundleContext;

public class RawUdpTransportManager
extends TransportManager {
    private static final Logger classLogger = Logger.getLogger(RawUdpTransportManager.class);
    private final Channel channel;
    private final int generation;
    private final String rtcpCandidateID;
    private final String rtpCandidateID;
    private final StreamConnector streamConnector;
    private boolean started = false;
    private final Logger logger;

    public RawUdpTransportManager(Channel channel) throws IOException {
        this.channel = channel;
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)channel.getContent().getConference().getLogger());
        this.addChannel(channel);
        this.streamConnector = this.createStreamConnector();
        this.generation = 0;
        this.rtpCandidateID = this.generateCandidateID();
        this.rtcpCandidateID = this.generateCandidateID();
    }

    @Override
    public boolean addChannel(Channel c) {
        return this.getChannels().isEmpty() ? super.addChannel(c) : false;
    }

    @Override
    public void close() {
        super.close();
        if (this.streamConnector != null) {
            this.streamConnector.close();
        }
    }

    @Override
    public boolean close(Channel channel) {
        if (channel == this.channel) {
            super.close(channel);
            channel.transportClosed();
            this.close();
            return true;
        }
        return false;
    }

    private static InetAddress getLocalHostLanAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress.isSiteLocalAddress()) {
                        return inetAddress;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddress;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    private StreamConnector createStreamConnector() throws IOException {
        BundleContext bundleContext = this.channel.getBundleContext();
        NetworkAddressManagerService nams = (NetworkAddressManagerService)ServiceUtils.getService((BundleContext)bundleContext, NetworkAddressManagerService.class);
        InetAddress bindAddr = null;
        if (nams != null) {
            Content content = this.channel.getContent();
            Conference conference = content.getConference();
            Videobridge videobridge = conference.getVideobridge();
            for (ComponentImpl component : videobridge.getComponents()) {
                String domain = component.getDomain();
                if (domain != null && domain.length() != 0) {
                    int subdomainEnd = domain.indexOf(46);
                    if (subdomainEnd >= 0) {
                        domain = domain.substring(subdomainEnd + 1);
                    }
                    if (domain.length() != 0) {
                        try {
                            bindAddr = nams.getLocalHost(NetworkUtils.getInetAddress((String)domain));
                        }
                        catch (UnknownHostException uhe) {
                            this.logger.info((Object)("Failed to get InetAddress from " + domain + " for channel " + this.channel.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "."), (Throwable)uhe);
                        }
                    }
                }
                if (bindAddr == null) continue;
                break;
            }
        }
        if (bindAddr == null) {
            String localAddressStr;
            ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
            InetAddress localAddress = null;
            if (cfg != null && (localAddressStr = cfg.getString("org.jitsi.videobridge.NAT_HARVESTER_LOCAL_ADDRESS")) != null && !localAddressStr.isEmpty()) {
                localAddress = InetAddress.getByName(localAddressStr);
            }
            bindAddr = localAddress != null ? localAddress : RawUdpTransportManager.getLocalHostLanAddress();
        }
        DefaultStreamConnector streamConnector = new DefaultStreamConnector(bindAddr);
        streamConnector.getDataSocket();
        streamConnector.getControlSocket();
        return streamConnector;
    }

    @Override
    public void describe(ColibriConferenceIQ.ChannelCommon iq) {
        super.describe(iq);
        IceUdpTransportPacketExtension transport = iq.getTransport();
        if (transport != null) {
            String host = null;
            int rtcpPort = 0;
            int rtpPort = 0;
            block4: for (CandidatePacketExtension candidate : transport.getCandidateList()) {
                switch (candidate.getComponent()) {
                    case 2: {
                        rtcpPort = candidate.getPort();
                        break;
                    }
                    case 1: {
                        rtpPort = candidate.getPort();
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                if (host != null && host.length() != 0) continue;
                host = candidate.getIP();
            }
            if (iq instanceof ColibriConferenceIQ.Channel) {
                ColibriConferenceIQ.Channel channelIq = (ColibriConferenceIQ.Channel)iq;
                channelIq.setHost(host);
                channelIq.setRTCPPort(rtcpPort);
                channelIq.setRTPPort(rtpPort);
            }
        }
    }

    @Override
    protected void describe(IceUdpTransportPacketExtension pe) {
        StreamConnector streamConnector = this.getStreamConnector(this.channel);
        DatagramSocket socket = streamConnector.getDataSocket();
        CandidatePacketExtension candidate = new CandidatePacketExtension();
        candidate.setComponent(1);
        candidate.setGeneration(this.generation);
        candidate.setID(this.rtpCandidateID);
        candidate.setIP(socket.getLocalAddress().getHostAddress());
        candidate.setPort(socket.getLocalPort());
        candidate.setType(CandidateType.host);
        pe.addCandidate(candidate);
        socket = streamConnector.getControlSocket();
        candidate = new CandidatePacketExtension();
        candidate.setComponent(2);
        candidate.setGeneration(this.generation);
        candidate.setID(this.rtcpCandidateID);
        candidate.setIP(socket.getLocalAddress().getHostAddress());
        candidate.setPort(socket.getLocalPort());
        candidate.setType(CandidateType.host);
        pe.addCandidate(candidate);
    }

    @Override
    public SrtpControl getSrtpControl(Channel channel) {
        return null;
    }

    @Override
    public StreamConnector getStreamConnector(Channel channel) {
        return this.streamConnector;
    }

    @Override
    public MediaStreamTarget getStreamTarget(Channel channel) {
        return null;
    }

    @Override
    public String getXmlNamespace() {
        return "urn:xmpp:jingle:transports:raw-udp:1";
    }

    @Override
    public void startConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
        if (this.started) {
            return;
        }
        if (!(transport instanceof RawUdpTransportPacketExtension)) {
            this.logger.error((Object)"Only RAW transport is accepted by this transport manager.");
            return;
        }
        this.channel.transportConnected();
        this.started = true;
    }

    @Override
    public boolean isConnected() {
        return true;
    }
}

