/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import net.java.sip.communicator.util.Logger;

public class Html2Text {
    private static final Logger logger = Logger.getLogger(Html2Text.class);
    private static HTMLParserCallback parser;

    public static synchronized String extractText(String html) {
        if (html == null) {
            return null;
        }
        if (parser == null) {
            parser = new HTMLParserCallback();
        }
        StringReader in = new StringReader(html);
        try {
            String string = parser.parse(in);
            in.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                if (logger.isInfoEnabled()) {
                    logger.info("Failed to extract plain text from html=" + html, ex);
                }
                return html;
            }
        }
    }

    private static class HTMLParserCallback
    extends HTMLEditorKit.ParserCallback {
        private StringBuilder sb;

        private HTMLParserCallback() {
        }

        public String parse(Reader in) throws IOException {
            String s;
            this.sb = new StringBuilder();
            try {
                new ParserDelegator().parse(in, this, true);
                s = this.sb.toString();
            }
            finally {
                this.sb = null;
            }
            return s;
        }

        @Override
        public void handleText(char[] text, int pos) {
            this.sb.append(text);
        }
    }
}

