/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.util.Collections;
import java.util.List;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class ColibriStatsExtension
extends AbstractPacketExtension {
    private static final Logger logger = Logger.getLogger(ColibriConferenceIQ.class);
    public static final String ELEMENT_NAME = "stats";
    public static final String NAMESPACE = "http://jitsi.org/protocol/colibri";

    private static Integer getInt(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        String str = obj.toString();
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Error parsing an int: " + obj));
            return null;
        }
    }

    public static ColibriStatsExtension clone(ColibriStatsExtension source) {
        ColibriStatsExtension destination = AbstractPacketExtension.clone(source);
        for (Stat stat : source.getChildExtensionsOfType(Stat.class)) {
            destination.addStat(Stat.clone(stat));
        }
        return destination;
    }

    public ColibriStatsExtension() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public void addStat(Stat stat) {
        this.addChildExtension(stat);
    }

    public void addStat(String name, Object value) {
        this.addStat(new Stat(name, value));
    }

    public Stat getStat(String name) {
        for (Stat stat : this.getChildExtensionsOfType(Stat.class)) {
            if (!stat.getName().equals(name)) continue;
            return stat;
        }
        return null;
    }

    public Object getValue(String name) {
        Stat stat = this.getStat(name);
        return stat == null ? null : stat.getValue();
    }

    public String getValueAsString(String name) {
        Object o = this.getValue(name);
        if (o != null) {
            return o instanceof String ? (String)o : o.toString();
        }
        return null;
    }

    public Integer getValueAsInt(String name) {
        return ColibriStatsExtension.getInt(this.getValue(name));
    }

    @Override
    public List<? extends ExtensionElement> getChildExtensions() {
        return Collections.unmodifiableList(super.getChildExtensions());
    }

    public static class Stat
    extends AbstractPacketExtension {
        public static final String ELEMENT_NAME = "stat";
        public static final String NAME_ATTR_NAME = "name";
        public static final String VALUE_ATTR_NAME = "value";

        public Stat() {
            super(ColibriStatsExtension.NAMESPACE, ELEMENT_NAME);
        }

        public Stat(String name, Object value) {
            this();
            this.setName(name);
            this.setValue(value);
        }

        @Override
        public String getElementName() {
            return ELEMENT_NAME;
        }

        public String getName() {
            return this.getAttributeAsString(NAME_ATTR_NAME);
        }

        @Override
        public String getNamespace() {
            return ColibriStatsExtension.NAMESPACE;
        }

        public Object getValue() {
            return this.getAttribute(VALUE_ATTR_NAME);
        }

        public void setName(String name) {
            this.setAttribute(NAME_ATTR_NAME, name);
        }

        public void setValue(Object value) {
            this.setAttribute(VALUE_ATTR_NAME, value);
        }

        @Override
        public String toXML() {
            String name = this.getName();
            Object value = this.getValue();
            if (name == null || value == null) {
                return "";
            }
            return new XmlStringBuilder().halfOpenElement(ELEMENT_NAME).attribute(NAME_ATTR_NAME, name).attribute(VALUE_ATTR_NAME, value.toString()).closeEmptyElement().toString();
        }
    }
}

