/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.UserID;
import org.jxmpp.jid.Jid;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OfferRevokeProvider
extends IQProvider<IQ> {
    public OfferRevokePacket parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
        Jid userJID;
        Jid userID = userJID = ParserUtils.getJidAttribute((XmlPullParser)parser);
        String reason = null;
        String sessionID = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && parser.getName().equals("reason")) {
                reason = parser.nextText();
                continue;
            }
            if (eventType == 2 && parser.getName().equals("session")) {
                sessionID = parser.getAttributeValue("", "id");
                continue;
            }
            if (eventType == 2 && parser.getName().equals("user")) {
                userID = ParserUtils.getJidAttribute((XmlPullParser)parser, (String)"id");
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("offer-revoke")) continue;
            done = true;
        }
        return new OfferRevokePacket(userJID, userID, reason, sessionID);
    }

    public static class OfferRevokePacket
    extends IQ {
        public static final String ELEMENT = "offer-revoke";
        public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
        private final Jid userJID;
        private final Jid userID;
        private final String sessionID;
        private final String reason;

        public OfferRevokePacket(Jid userJID, Jid userID, String cause, String sessionID) {
            super(ELEMENT, NAMESPACE);
            this.userJID = userJID;
            this.userID = userID;
            this.reason = cause;
            this.sessionID = sessionID;
        }

        public Jid getUserJID() {
            return this.userJID;
        }

        public Jid getUserID() {
            return this.userID;
        }

        public String getReason() {
            return this.reason;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
            buf.append((CharSequence)" jid=\"").append((CharSequence)this.userID).append((CharSequence)"\">");
            if (this.reason != null) {
                buf.append((CharSequence)"<reason>").append((CharSequence)this.reason).append((CharSequence)"</reason>");
            }
            if (this.sessionID != null) {
                buf.append((CharSequence)new SessionID(this.sessionID).toXML());
            }
            if (this.userID != null) {
                buf.append((CharSequence)new UserID(this.userID).toXML());
            }
            return buf;
        }
    }
}

