/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.osgi;

import java.util.Collection;
import java.util.LinkedList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceUtils2 {
    public static <T> T getService(BundleContext bundleContext, Class<T> serviceClass) {
        ServiceReference serviceReference = bundleContext == null ? null : bundleContext.getServiceReference(serviceClass);
        return (T)(serviceReference == null ? null : bundleContext.getService(serviceReference));
    }

    public static <T> Collection<T> getServices(BundleContext bundleContext, Class<T> serviceClass) {
        LinkedList<Object> services = new LinkedList<Object>();
        if (bundleContext != null) {
            Collection serviceReferences = null;
            try {
                serviceReferences = bundleContext.getServiceReferences(serviceClass, null);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            if (serviceReferences != null) {
                for (ServiceReference serviceReference : serviceReferences) {
                    Object service = null;
                    try {
                        service = bundleContext.getService(serviceReference);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalStateException e) {
                        break;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (service == null || services.contains(service)) continue;
                    services.add(service);
                }
            }
        }
        return services;
    }

    private ServiceUtils2() {
    }
}

