/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import net.java.sip.communicator.impl.protocol.jabber.ChatRoomMemberJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ServerStoredContactListJabberImpl;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;

public class VolatileContactJabberImpl
extends ContactJabberImpl {
    private Jid contactId = null;
    private boolean isPrivateMessagingContact = false;
    protected String displayName = null;

    VolatileContactJabberImpl(Jid id, ServerStoredContactListJabberImpl ssclCallback) {
        this(id, ssclCallback, false, null);
    }

    VolatileContactJabberImpl(Jid id, ServerStoredContactListJabberImpl ssclCallback, boolean isPrivateMessagingContact) {
        this(id, ssclCallback, isPrivateMessagingContact, null);
    }

    VolatileContactJabberImpl(Jid id, ServerStoredContactListJabberImpl ssclCallback, boolean isPrivateMessagingContact, String displayName) {
        super(null, ssclCallback, false, false);
        this.isPrivateMessagingContact = isPrivateMessagingContact;
        if (this.isPrivateMessagingContact) {
            this.displayName = id.getResourceOrEmpty() + " from " + id.asBareJid();
            this.contactId = id;
            this.setJid(id);
        } else {
            this.contactId = id.asBareJid();
            this.displayName = displayName == null ? this.contactId.toString() : displayName;
            Resourcepart resource = id.getResourceOrNull();
            if (resource != null) {
                this.setJid(id);
            }
        }
    }

    @Override
    public String getAddress() {
        return this.contactId.toString();
    }

    @Override
    public Jid getAddressAsJid() {
        return this.contactId;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer("VolatileJabberContact[ id=");
        buff.append(this.getAddress()).append("]");
        return buff.toString();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    public boolean isPrivateMessagingContact() {
        return this.isPrivateMessagingContact;
    }

    public String getPersistableAddress() {
        if (!this.isPrivateMessagingContact) {
            return this.getAddress();
        }
        ChatRoomMemberJabberImpl chatRoomMember = null;
        OperationSetMultiUserChatJabberImpl mucOpSet = (OperationSetMultiUserChatJabberImpl)this.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class);
        if (mucOpSet != null) {
            chatRoomMember = mucOpSet.getChatRoom(this.contactId.asBareJid()).findMemberForNickName(this.contactId.getResourceOrEmpty());
        }
        return chatRoomMember == null ? null : chatRoomMember.getJabberID().asBareJid().toString();
    }
}

