/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="set-scm-tag", aggregator=true, threadSafe=true)
public class SetScmTagMojo
extends AbstractVersionsUpdaterMojo {
    @Parameter(property="newTag")
    private String newTag;
    @Parameter(property="connection")
    private String connection;
    @Parameter(property="developerConnection")
    private String developerConnection;
    @Parameter(property="url")
    private String url;

    @Inject
    public SetScmTagMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.newTag, this.connection, this.developerConnection, this.url})) {
            throw new MojoFailureException("One of: \"newTag\", \"connection\", \"developerConnection\", \"url\" should be provided.");
        }
        super.execute();
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            Scm scm = PomHelper.getRawModel((ModifiedPomXMLEventReader)pom).getScm();
            if (scm == null) {
                throw new MojoFailureException("No <scm> was present");
            }
            ArrayList<String> failures = new ArrayList<String>();
            if (!StringUtils.isBlank((CharSequence)this.newTag)) {
                this.getLog().info((CharSequence)("Updating tag: " + (scm != null && scm.getTag() != null ? scm.getTag() : "(empty)") + " -> " + this.newTag));
                if (!PomHelper.setElementValue((ModifiedPomXMLEventReader)pom, (String)"/project/scm", (String)"tag", (String)this.newTag)) {
                    failures.add("tag: " + this.newTag);
                }
            }
            if (!StringUtils.isBlank((CharSequence)this.connection)) {
                this.getLog().info((CharSequence)("Updating connection: " + (scm != null && scm.getConnection() != null ? scm.getConnection() : "(empty)") + " -> " + this.connection));
                if (!PomHelper.setElementValue((ModifiedPomXMLEventReader)pom, (String)"/project/scm", (String)"connection", (String)this.connection)) {
                    failures.add("connection: " + this.connection);
                }
            }
            if (!StringUtils.isBlank((CharSequence)this.developerConnection)) {
                this.getLog().info((CharSequence)("Updating developerConnection: " + (scm != null && scm.getDeveloperConnection() != null ? scm.getDeveloperConnection() : "(empty)") + " -> " + this.developerConnection));
                if (!PomHelper.setElementValue((ModifiedPomXMLEventReader)pom, (String)"/project/scm", (String)"developerConnection", (String)this.developerConnection)) {
                    failures.add("developerConnection: " + this.developerConnection);
                }
            }
            if (!StringUtils.isBlank((CharSequence)this.url)) {
                this.getLog().info((CharSequence)("Updating url: " + (scm != null && scm.getUrl() != null ? scm.getUrl() : "(empty)") + " -> " + this.url));
                if (!PomHelper.setElementValue((ModifiedPomXMLEventReader)pom, (String)"/project/scm", (String)"url", (String)this.url)) {
                    failures.add("url: " + this.url);
                }
            }
            if (!failures.isEmpty()) {
                throw new MojoFailureException("Could not update one or more SCM elements: " + String.join((CharSequence)", ", failures) + ". Please make sure they are present in the original POM. ");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

