/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.util.List;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;

public class SourcePacketExtension
extends AbstractPacketExtension {
    private static final Logger logger = Logger.getLogger(SourcePacketExtension.class);
    public static final String ELEMENT_NAME = "source";
    public static final String NAMESPACE = "urn:xmpp:jingle:apps:rtp:ssma:0";
    public static final String SSRC_ATTR_NAME = "ssrc";
    public static final String RID_ATTR_NAME = "rid";

    public SourcePacketExtension() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public void addParameter(ParameterPacketExtension parameter) {
        this.addChildExtension(parameter);
    }

    public List<ParameterPacketExtension> getParameters() {
        return this.getChildExtensionsOfType(ParameterPacketExtension.class);
    }

    public String getParameter(String name) {
        for (ParameterPacketExtension param : this.getParameters()) {
            if (!name.equals(param.getName())) continue;
            return param.getValue();
        }
        return null;
    }

    public long getSSRC() {
        String s = this.getAttributeAsString(SSRC_ATTR_NAME);
        return s == null ? -1L : Long.parseLong(s);
    }

    public void setSSRC(long ssrc) {
        if (ssrc == -1L) {
            this.removeAttribute(SSRC_ATTR_NAME);
        } else {
            this.setAttribute(SSRC_ATTR_NAME, Long.toString(0xFFFFFFFFL & ssrc));
        }
    }

    public boolean hasSSRC() {
        return this.getAttributeAsString(SSRC_ATTR_NAME) != null;
    }

    public String getRid() {
        return this.getAttributeAsString(RID_ATTR_NAME);
    }

    public void setRid(String rid) {
        if (rid == null) {
            this.removeAttribute(RID_ATTR_NAME);
        } else {
            this.setAttribute(RID_ATTR_NAME, rid);
        }
    }

    public boolean hasRid() {
        return this.getAttribute(RID_ATTR_NAME) != null;
    }

    public boolean sourceEquals(SourcePacketExtension other) {
        if (this.hasSSRC() && other.hasSSRC()) {
            return this.getSSRC() == other.getSSRC();
        }
        if (this.hasRid() && other.hasRid()) {
            return this.getRid().equals(other.getRid());
        }
        return false;
    }

    public SourcePacketExtension copy() {
        SourcePacketExtension copy = AbstractPacketExtension.clone(this);
        for (ExtensionElement extensionElement : this.getChildExtensions()) {
            if (extensionElement instanceof AbstractPacketExtension) {
                copy.addChildExtension(AbstractPacketExtension.clone((AbstractPacketExtension)extensionElement));
                continue;
            }
            logger.error((Object)("Failed to clone " + extensionElement));
        }
        return copy;
    }

    public String toString() {
        if (this.hasRid()) {
            return "rid=" + this.getRid();
        }
        if (this.hasSSRC()) {
            return "ssrc=" + this.getAttributeAsString(SSRC_ATTR_NAME);
        }
        return "[no identifier]";
    }
}

